/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.handler;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.camel.CamelContext;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.camel.utils.IllegalStateAssertion;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.handler.SecurityActions;
import org.wildfly.extension.camel.service.CamelContextRegistryService;

public final class ModuleClassLoaderAssociationHandler
implements ContextCreateHandler {
    private static ThreadLocal<ModuleClassLoader> moduleClassLoaderAssociation = new ThreadLocal();

    @Override
    public void setup(CamelContext camelctx) {
        ModuleClassLoader moduleClassLoader = ModuleClassLoaderAssociationHandler.getModuleClassLoader(camelctx);
        camelctx.setApplicationContextClassLoader((ClassLoader)moduleClassLoader);
    }

    public static void associate(ModuleClassLoader modcl) {
        moduleClassLoaderAssociation.set(modcl);
    }

    public static void disassociate() {
        moduleClassLoaderAssociation.remove();
    }

    public static ModuleClassLoader getModuleClassLoader(CamelContext camelctx) {
        Module tcm;
        ClassLoader tccl;
        ModuleClassLoader moduleClassLoader;
        Module contextModule = null;
        ClassLoader applicationClassLoader = camelctx.getApplicationContextClassLoader();
        if (applicationClassLoader instanceof ModuleClassLoader) {
            contextModule = ((ModuleClassLoader)applicationClassLoader).getModule();
        }
        if ((moduleClassLoader = moduleClassLoaderAssociation.get()) != null) {
            contextModule = moduleClassLoader.getModule();
        }
        if (contextModule == null) {
            ClassLoader thiscl = CamelContextRegistryService.class.getClassLoader();
            ClassLoader tccl2 = SecurityActions.getContextClassLoader();
            if (tccl2 == thiscl) {
                contextModule = ((ModuleClassLoader)thiscl).getModule();
            }
        }
        if (contextModule == null && (tccl = SecurityActions.getContextClassLoader()) instanceof ModuleClassLoader && (tcm = ((ModuleClassLoader)tccl).getModule()).getIdentifier().getName().startsWith("deployment.")) {
            contextModule = tcm;
        }
        if (contextModule == null) {
            Class<?> callingClass = CallerContext.getCallingClass();
            contextModule = ((ModuleClassLoader)callingClass.getClassLoader()).getModule();
        }
        IllegalStateAssertion.assertNotNull((Object)contextModule, (String)("Cannot obtain module for: " + camelctx));
        return contextModule.getClassLoader();
    }

    static final class CallerContext {
        private static Hack hack = AccessController.doPrivileged(new PrivilegedAction<Hack>(){

            @Override
            public Hack run() {
                return new Hack();
            }
        });

        private CallerContext() {
        }

        static Class<?> getCallingClass() {
            Class<?>[] stack = hack.getClassContext();
            int i = 3;
            while (stack[i] == stack[2]) {
                if (++i < stack.length) continue;
                return null;
            }
            Class<?> result = stack[i];
            while (CallerContext.ignoreCaller(result.getName())) {
                result = stack[++i];
            }
            return result;
        }

        private static boolean ignoreCaller(String caller) {
            boolean result = caller.startsWith("org.wildfly.extension.camel");
            result |= caller.startsWith("org.springframework");
            return result |= caller.startsWith("org.apache.camel");
        }

        private static final class Hack
        extends SecurityManager {
            private Hack() {
            }

            @Override
            protected Class<?>[] getClassContext() {
                return super.getClassContext();
            }
        }
    }
}

