/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.parser;

import java.util.function.Consumer;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.camel.CamelSubsytemExtension;
import org.wildfly.extension.camel.deployment.CamelContextActivationProcessor;
import org.wildfly.extension.camel.deployment.CamelContextBootstrapProcessor;
import org.wildfly.extension.camel.deployment.CamelContextDescriptorsProcessor;
import org.wildfly.extension.camel.deployment.CamelDependenciesProcessor;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettingsBuilderProcessor;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettingsProcessor;
import org.wildfly.extension.camel.deployment.CamelEndpointDeployerProcessor;
import org.wildfly.extension.camel.deployment.CamelEndpointDeploymentSchedulerProcessor;
import org.wildfly.extension.camel.deployment.CamelIntegrationProcessor;
import org.wildfly.extension.camel.deployment.PackageScanResolverProcessor;
import org.wildfly.extension.camel.parser.SubsystemState;
import org.wildfly.extension.camel.service.CamelBootstrapService;
import org.wildfly.extension.camel.service.CamelContextFactoryService;
import org.wildfly.extension.camel.service.CamelContextRegistryService;
import org.wildfly.extension.camel.service.ContextCreateHandlerRegistryService;

public final class CamelSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final int STRUCTURE_REGISTER_CAMEL_INTEGRATION = 2783;
    public static final int PARSE_DEPLOYMENT_SETTINGS = 770;
    public static final int PARSE_CAMEL_CONTEXT_DESCRIPTORS = 771;
    public static final int DEPENDENCIES_DEPLOYMENT_SETTINGS = 7425;
    public static final int DEPENDENCIES_CAMEL_INTEGRATION = 7426;
    public static final int DEPENDENCIES_CAMEL_WIRINGS = 7427;
    public static final int DEPENDENCIES_CAMEL_ENDPOINT_DEPLOYMENT_SCHEDULER = 7428;
    public static final int INSTALL_PACKAGE_SCAN_RESOLVER = 7186;
    public static final int INSTALL_CDI_BEAN_ARCHIVE_PROCESSOR = 7187;
    public static final int INSTALL_CAMEL_CONTEXT_CREATE = 7188;
    public static final int INSTALL_CONTEXT_ACTIVATION = 7189;
    public static final int INSTALL_CAMEL_ENDPOINT_DEPLOYER = 7425;
    private final SubsystemState subsystemState;

    public CamelSubsystemAdd(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performBoottime(final OperationContext context, ModelNode operation, ModelNode model) {
        CamelBootstrapService.addService(context.getServiceTarget());
        CamelContextFactoryService.addService(context.getServiceTarget());
        CamelContextRegistryService.addService(context.getServiceTarget(), this.subsystemState);
        ContextCreateHandlerRegistryService.addService(context.getServiceTarget(), this.subsystemState);
        this.subsystemState.processExtensions(new Consumer<CamelSubsytemExtension>(){

            @Override
            public void accept(CamelSubsytemExtension plugin) {
                plugin.addExtensionServices(context.getServiceTarget(), CamelSubsystemAdd.this.subsystemState);
            }
        });
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(final DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("camel", Phase.PARSE, 770, (DeploymentUnitProcessor)new CamelDeploymentSettingsBuilderProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.PARSE, 771, (DeploymentUnitProcessor)new CamelContextDescriptorsProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.DEPENDENCIES, 7425, (DeploymentUnitProcessor)new CamelDeploymentSettingsProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.DEPENDENCIES, 7426, (DeploymentUnitProcessor)new CamelIntegrationProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.DEPENDENCIES, 7427, (DeploymentUnitProcessor)new CamelDependenciesProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.DEPENDENCIES, 7428, (DeploymentUnitProcessor)new CamelEndpointDeploymentSchedulerProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 7186, (DeploymentUnitProcessor)new PackageScanResolverProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 7188, (DeploymentUnitProcessor)new CamelContextBootstrapProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 7189, (DeploymentUnitProcessor)new CamelContextActivationProcessor());
                processorTarget.addDeploymentProcessor("camel", Phase.INSTALL, 7425, (DeploymentUnitProcessor)new CamelEndpointDeployerProcessor());
                CamelSubsystemAdd.this.subsystemState.processExtensions(new Consumer<CamelSubsytemExtension>(){

                    @Override
                    public void accept(CamelSubsytemExtension plugin) {
                        plugin.addDeploymentProcessor(processorTarget, CamelSubsystemAdd.this.subsystemState);
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

