/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.as.server.deployment.AttachmentKey;

public final class CamelDeploymentSettings {
    public static final AttachmentKey<CamelDeploymentSettings> ATTACHMENT_KEY = AttachmentKey.create(CamelDeploymentSettings.class);
    public static final AttachmentKey<Builder> BUILDER_ATTACHMENT_KEY = AttachmentKey.create(Builder.class);
    private static final Map<String, CamelDeploymentSettings> deploymentSettingsMap = new HashMap<String, CamelDeploymentSettings>();
    private final List<String> dependencies;
    private final List<URL> camelContextUrls;
    private final boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CamelDeploymentSettings get(String name) {
        Map<String, CamelDeploymentSettings> map = deploymentSettingsMap;
        synchronized (map) {
            return deploymentSettingsMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String deploymentName) {
        Map<String, CamelDeploymentSettings> map = deploymentSettingsMap;
        synchronized (map) {
            deploymentSettingsMap.remove(deploymentName);
        }
    }

    private CamelDeploymentSettings(List<String> dependencies, List<URL> camelContextUrls, boolean enabled) {
        this.dependencies = dependencies;
        this.camelContextUrls = camelContextUrls;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getModuleDependencies() {
        return this.dependencies;
    }

    public List<URL> getCamelContextUrls() {
        return this.camelContextUrls;
    }

    public static class Builder {
        private boolean camelAnnotationPresent;
        private List<URL> camelContextUrls = new ArrayList<URL>();
        private List<Map.Entry<Builder, Consumer<CamelDeploymentSettings>>> children = new ArrayList<Map.Entry<Builder, Consumer<CamelDeploymentSettings>>>();
        private List<String> dependencies = new ArrayList<String>();
        private String deploymentName;
        private boolean deploymentValid;
        private boolean disabledByJbossAll;
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CamelDeploymentSettings build() {
            List<URL> urls;
            List<String> deps;
            boolean enabled;
            Object object = this.lock;
            synchronized (object) {
                enabled = this.isEnabled();
                for (Map.Entry<Builder, Consumer<CamelDeploymentSettings>> e : this.children) {
                    CamelDeploymentSettings childDepSettings = e.getKey().build();
                    e.getValue().accept(childDepSettings);
                }
                this.children = null;
                deps = Collections.unmodifiableList(this.dependencies);
                this.dependencies = null;
                urls = Collections.unmodifiableList(this.camelContextUrls);
                this.camelContextUrls = null;
            }
            CamelDeploymentSettings result = new CamelDeploymentSettings(deps, urls, enabled);
            Map map = deploymentSettingsMap;
            synchronized (map) {
                deploymentSettingsMap.put(this.deploymentName, result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder camelAnnotationPresent(boolean camelAnnotationPresent) {
            Object object = this.lock;
            synchronized (object) {
                this.camelAnnotationPresent = camelAnnotationPresent;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder camelContextUrl(URL camelContextUrl) {
            Object object = this.lock;
            synchronized (object) {
                this.camelContextUrls.add(camelContextUrl);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder child(Builder depSettingsBuilder, Consumer<CamelDeploymentSettings> consumer) {
            Object object = this.lock;
            synchronized (object) {
                this.children.add(new AbstractMap.SimpleImmutableEntry<Builder, Consumer<CamelDeploymentSettings>>(depSettingsBuilder, consumer));
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder dependency(String dependency) {
            Object object = this.lock;
            synchronized (object) {
                this.dependencies.add(dependency);
                this.disabledByJbossAll = false;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder deploymentName(String deploymentName) {
            Object object = this.lock;
            synchronized (object) {
                this.deploymentName = deploymentName;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder deploymentValid(boolean deploymentValid) {
            Object object = this.lock;
            synchronized (object) {
                this.deploymentValid = deploymentValid;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder disabledByJbossAll(boolean disabledByJbossAll) {
            Object object = this.lock;
            synchronized (object) {
                this.disabledByJbossAll = disabledByJbossAll;
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDeploymentValid() {
            Object object = this.lock;
            synchronized (object) {
                return this.deploymentValid;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDisabledByJbossAll() {
            Object object = this.lock;
            synchronized (object) {
                return this.disabledByJbossAll;
            }
        }

        private boolean isEnabled() {
            if (this.disabledByJbossAll) {
                return false;
            }
            if (this.deploymentValid) {
                if (!this.camelContextUrls.isEmpty()) {
                    return true;
                }
                for (Map.Entry<Builder, Consumer<CamelDeploymentSettings>> e : this.children) {
                    if (!e.getKey().isEnabled()) continue;
                    return true;
                }
                if (this.camelAnnotationPresent) {
                    return true;
                }
                if (!this.dependencies.isEmpty()) {
                    return true;
                }
            }
            return false;
        }
    }
}

