/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.camel.proxy.ProxiedAction;
import org.wildfly.camel.proxy.ProxyUtils;
import org.wildfly.camel.utils.SpringCamelContextBootstrap;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.service.SecurityActions;

public final class CamelContextActivationService
extends AbstractService<Void> {
    private final List<SpringCamelContextBootstrap> bootstraps;
    private final String runtimeName;

    public CamelContextActivationService(List<SpringCamelContextBootstrap> bootstraps, String runtimeName) {
        this.bootstraps = bootstraps;
        this.runtimeName = runtimeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        for (SpringCamelContextBootstrap bootstrap : this.bootstraps) {
            try {
                SecurityActions.setContextClassLoader(bootstrap.getClassLoader());
                try {
                    for (final CamelContext camelctx : bootstrap.createSpringCamelContexts()) {
                        try {
                            ProxyUtils.invokeProxied((ProxiedAction)new ProxiedAction(){

                                public void run() throws Exception {
                                    camelctx.start();
                                }
                            }, (ClassLoader)bootstrap.getClassLoader());
                        }
                        catch (Exception ex) {
                            throw new StartException("Cannot start camel context: " + camelctx.getName(), (Throwable)ex);
                        }
                    }
                }
                catch (Exception e) {
                    throw new StartException("Cannot create camel context: " + this.runtimeName, (Throwable)e);
                }
            }
            finally {
                SecurityActions.setContextClassLoader(tccl);
            }
        }
    }

    public void stop(StopContext context) {
        Collections.reverse(this.bootstraps);
        for (SpringCamelContextBootstrap bootstrap : this.bootstraps) {
            List camelctxList = bootstrap.getSpringCamelContexts();
            for (CamelContext camelctx : camelctxList) {
                try {
                    camelctx.stop();
                }
                catch (Exception ex) {
                    CamelLogger.LOGGER.warn("Cannot stop camel context: " + camelctx.getName(), (Throwable)ex);
                }
            }
        }
    }
}

