/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.core.DeploymentImpl;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.service.CamelEndpointDeploymentSchedulerService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentInfoService;

public class CamelEndpointDeployerService
implements Service<CamelEndpointDeployerService> {
    private static final String MATCH_ALL_ENDPOINT_URI_PREFIX = "///*";
    private static final String MATCH_ALL_PREFIX = "/*";
    private static final String SERVICE_NAME = "EndpointDeployer";
    private static final ThreadLocal<HttpServerExchange> exchangeThreadLocal = new ThreadLocal();
    private static final HandlerWrapper exchangeStoringHandlerWrapper = new HandlerWrapper(){

        public HttpHandler wrap(HttpHandler handler) {
            return exchange -> {
                exchangeThreadLocal.set(exchange);
                try {
                    handler.handleRequest(exchange);
                }
                finally {
                    exchangeThreadLocal.remove();
                }
            };
        }
    };
    private final InjectedValue<DeploymentInfo> deploymentInfoSupplier = new InjectedValue();
    private final Map<URI, DeploymentManager> deployments = new HashMap<URI, DeploymentManager>();
    private final InjectedValue<CamelEndpointDeploymentSchedulerService> deploymentSchedulerServiceSupplier = new InjectedValue();
    private final InjectedValue<Host> hostSupplier = new InjectedValue();
    private final InjectedValue<ServletContainerService> servletContainerServiceSupplier = new InjectedValue();

    static DeploymentInfo adaptDeploymentInfo(DeploymentInfo src, URI uri, ServletInfo servletInfo) {
        String contextPath = uri.getPath();
        String deploymentName = src.getDeploymentName() + ":" + uri.getPath();
        DeploymentInfo info = new DeploymentInfo().setClassLoader(src.getClassLoader()).setContextPath(contextPath).setResourceManager(src.getResourceManager()).setMajorVersion(src.getMajorVersion()).setMinorVersion(src.getMinorVersion()).setDeploymentName(deploymentName).setClassIntrospecter(src.getClassIntrospecter());
        info.addServlet(servletInfo);
        for (Map.Entry e2 : src.getFilters().entrySet()) {
            info.addFilter(((FilterInfo)e2.getValue()).clone());
        }
        info.setDisplayName(src.getDisplayName());
        block7: for (FilterMappingInfo fmi : src.getFilterMappings()) {
            switch (fmi.getMappingType()) {
                case URL: {
                    info.addFilterUrlMapping(fmi.getFilterName(), fmi.getMapping(), fmi.getDispatcher());
                    continue block7;
                }
                case SERVLET: {
                    info.addFilterServletNameMapping(fmi.getFilterName(), fmi.getMapping(), fmi.getDispatcher());
                    continue block7;
                }
            }
            throw new IllegalStateException("Unexpected " + FilterMappingInfo.MappingType.class.getName() + " " + fmi.getMappingType());
        }
        List listeners = src.getListeners();
        List<String> approvedListeners = Arrays.asList("org.wildfly.extension.undertow.deployment.JspInitializationListener", "org.jboss.weld.module.web.servlet.WeldInitialListener", "org.jboss.weld.module.web.servlet.WeldTerminalListener", "org.wildfly.microprofile.opentracing.smallrye.TracerInitializer");
        String infoServiceListenerClassNamePrefix = UndertowDeploymentInfoService.class.getName() + "$";
        for (ListenerInfo listenerInfo : listeners) {
            CamelLogger.LOGGER.debug("Copying ListenerInfo {}", (Object)listenerInfo);
            if (listenerInfo.getListenerClass().getName().startsWith(infoServiceListenerClassNamePrefix)) continue;
            assert (approvedListeners.stream().anyMatch(cl -> cl.equals(listenerInfo.getListenerClass().getName()))) : "Unexpected " + ListenerInfo.class.getName() + ": " + listenerInfo + "; expected any of [" + approvedListeners.stream().collect(Collectors.joining(", ")) + "]";
            info.addListener(listenerInfo);
        }
        info.addServletContainerInitalizers(src.getServletContainerInitializers());
        for (ThreadSetupHandler threadSetupHandler : src.getThreadSetupActions()) {
            info.addThreadSetupAction(threadSetupHandler);
        }
        for (Map.Entry entry : src.getInitParameters().entrySet()) {
            info.addInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : src.getServletContextAttributes().entrySet()) {
            if ("io.undertow.websockets.jsr.WebSocketDeploymentInfo".equals(entry.getKey())) {
                WebSocketDeploymentInfo webSocketDeploymentInfo = (WebSocketDeploymentInfo)entry.getValue();
                WebSocketDeploymentInfo targetWsdi = new WebSocketDeploymentInfo().setWorker(webSocketDeploymentInfo.getWorker()).setBuffers(webSocketDeploymentInfo.getBuffers()).setDispatchToWorkerThread(webSocketDeploymentInfo.isDispatchToWorkerThread()).setReconnectHandler(webSocketDeploymentInfo.getReconnectHandler());
                targetWsdi.setClientBindAddress(webSocketDeploymentInfo.getClientBindAddress());
                webSocketDeploymentInfo.getAnnotatedEndpoints().stream().forEach(e -> targetWsdi.addEndpoint(e));
                webSocketDeploymentInfo.getProgramaticEndpoints().stream().forEach(e -> targetWsdi.addEndpoint(e));
                webSocketDeploymentInfo.getExtensions().stream().forEach(e -> targetWsdi.addExtension(e));
                try {
                    Field containerReadyListenersField = webSocketDeploymentInfo.getClass().getDeclaredField("containerReadyListeners");
                    containerReadyListenersField.setAccessible(true);
                    List containerReadyListeners = (List)containerReadyListenersField.get(webSocketDeploymentInfo);
                    assert (containerReadyListeners.stream().anyMatch(l -> l.getClass().getName().startsWith(infoServiceListenerClassNamePrefix))) : infoServiceListenerClassNamePrefix + "* not found in " + WebSocketDeploymentInfo.class.getSimpleName() + ".containerReadyListeners";
                    assert (containerReadyListeners.size() == 1) : WebSocketDeploymentInfo.class.getSimpleName() + ".containerReadyListeners.size() expected 1, actual " + listeners.size();
                    continue;
                }
                catch (IllegalAccessException | NoSuchFieldException | SecurityException e1) {
                    throw new RuntimeException(e1);
                }
            }
            info.addServletContextAttribute((String)entry.getKey(), entry.getValue());
        }
        info.addWelcomePages((Collection)src.getWelcomePages());
        info.addErrorPages((Collection)src.getErrorPages());
        info.addMimeMappings((Collection)src.getMimeMappings());
        info.setExecutor(src.getExecutor());
        info.setAsyncExecutor(src.getAsyncExecutor());
        info.setTempDir(src.getTempDir());
        info.setJspConfigDescriptor(src.getJspConfigDescriptor());
        info.setDefaultServletConfig(src.getDefaultServletConfig());
        for (Map.Entry entry : src.getLocaleCharsetMapping().entrySet()) {
            info.addLocaleCharsetMapping((String)entry.getKey(), (String)entry.getValue());
        }
        info.setSessionManagerFactory(src.getSessionManagerFactory());
        LoginConfig loginConfig = src.getLoginConfig();
        if (loginConfig != null) {
            info.setLoginConfig(loginConfig.clone());
        }
        info.setIdentityManager(src.getIdentityManager());
        info.setConfidentialPortManager(src.getConfidentialPortManager());
        info.setDefaultEncoding(src.getDefaultEncoding());
        info.setUrlEncoding(src.getUrlEncoding());
        info.addSecurityConstraints(CamelEndpointDeployerService.filterConstraints(src, uri));
        for (HandlerWrapper handlerWrapper : src.getOuterHandlerChainWrappers()) {
            info.addOuterHandlerChainWrapper(handlerWrapper);
        }
        for (HandlerWrapper handlerWrapper : src.getInnerHandlerChainWrappers()) {
            info.addInnerHandlerChainWrapper(handlerWrapper);
        }
        info.setInitialSecurityWrapper(src.getInitialSecurityWrapper());
        for (HandlerWrapper handlerWrapper : src.getSecurityWrappers()) {
            info.addSecurityWrapper(handlerWrapper);
        }
        for (HandlerWrapper handlerWrapper : src.getInitialHandlerChainWrappers()) {
            info.addInitialHandlerChainWrapper(handlerWrapper);
        }
        info.addSecurityRoles((Collection)src.getSecurityRoles());
        info.addNotificationReceivers((Collection)src.getNotificationReceivers());
        info.setAllowNonStandardWrappers(src.isAllowNonStandardWrappers());
        info.setDefaultSessionTimeout(src.getDefaultSessionTimeout());
        info.setServletContextAttributeBackingMap(src.getServletContextAttributeBackingMap());
        info.setServletSessionConfig(src.getServletSessionConfig());
        info.setHostName(src.getHostName());
        info.setDenyUncoveredHttpMethods(src.isDenyUncoveredHttpMethods());
        info.setServletStackTraces(src.getServletStackTraces());
        info.setInvalidateSessionOnLogout(src.isInvalidateSessionOnLogout());
        info.setDefaultCookieVersion(src.getDefaultCookieVersion());
        info.setSessionPersistenceManager(src.getSessionPersistenceManager());
        for (Map.Entry entry : src.getPrincipalVersusRolesMap().entrySet()) {
            info.addPrincipalVsRoleMappings((String)entry.getKey(), (Collection)entry.getValue());
        }
        info.setIgnoreFlush(src.isIgnoreFlush());
        info.setAuthorizationManager(src.getAuthorizationManager());
        for (Map.Entry entry : src.getAuthenticationMechanisms().entrySet()) {
            info.addAuthenticationMechanism((String)entry.getKey(), (AuthenticationMechanismFactory)entry.getValue());
        }
        info.setJaspiAuthenticationMechanism(src.getJaspiAuthenticationMechanism());
        info.setSecurityContextFactory(src.getSecurityContextFactory());
        info.setServerName(src.getServerName());
        info.setMetricsCollector(src.getMetricsCollector());
        info.setSessionConfigWrapper(src.getSessionConfigWrapper());
        info.setEagerFilterInit(src.isEagerFilterInit());
        info.setDisableCachingForSecuredPages(src.isDisableCachingForSecuredPages());
        info.setExceptionHandler(src.getExceptionHandler());
        info.setEscapeErrorMessage(src.isEscapeErrorMessage());
        for (SessionListener sessionListener : src.getSessionListeners()) {
            info.addSessionListener(sessionListener);
        }
        for (LifecycleInterceptor lifecycleInterceptor : src.getLifecycleInterceptors()) {
            info.addLifecycleInterceptor(lifecycleInterceptor);
        }
        info.setAuthenticationMode(src.getAuthenticationMode());
        info.setDefaultMultipartConfig(src.getDefaultMultipartConfig());
        info.setContentTypeCacheSize(src.getContentTypeCacheSize());
        info.setSessionIdGenerator(src.getSessionIdGenerator());
        info.setSendCustomReasonPhraseOnError(src.isSendCustomReasonPhraseOnError());
        info.setChangeSessionIdOnLogin(src.isChangeSessionIdOnLogin());
        info.setCrawlerSessionManagerConfig(src.getCrawlerSessionManagerConfig());
        info.setSecurityDisabled(src.isSecurityDisabled());
        info.setUseCachedAuthenticationMechanism(src.isUseCachedAuthenticationMechanism());
        info.setCheckOtherSessionManagers(src.isCheckOtherSessionManagers());
        return info;
    }

    public static ServiceController<CamelEndpointDeployerService> addService(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, ServiceName deploymentInfoServiceName, ServiceName hostServiceName) {
        CamelEndpointDeployerService service = new CamelEndpointDeployerService();
        ServiceBuilder sb = serviceTarget.addService(CamelEndpointDeployerService.deployerServiceName(deploymentUnit.getServiceName()), (Service)service);
        sb.addDependency(hostServiceName, Host.class, service.hostSupplier);
        sb.addDependency(deploymentInfoServiceName, DeploymentInfo.class, service.deploymentInfoSupplier);
        sb.addDependency(CamelEndpointDeploymentSchedulerService.deploymentSchedulerServiceName(deploymentUnit.getServiceName()), CamelEndpointDeploymentSchedulerService.class, service.deploymentSchedulerServiceSupplier);
        sb.addDependency(UndertowService.SERVLET_CONTAINER.append(new String[]{"default"}), ServletContainerService.class, service.servletContainerServiceSupplier);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration != null) {
            for (ComponentConfiguration c : moduleConfiguration.getComponentConfigurations()) {
                sb.addDependency(c.getComponentDescription().getStartServiceName());
            }
        }
        return sb.install();
    }

    public static ServiceName deployerServiceName(ServiceName deploymentUnitServiceName) {
        return deploymentUnitServiceName.append(new String[]{SERVICE_NAME});
    }

    static List<SecurityConstraint> filterConstraints(DeploymentInfo mainDeploymentInfo, URI uri) {
        ArrayList<SecurityConstraint> result = new ArrayList<SecurityConstraint>();
        String uriPath = uri.getPath();
        String endpointUriPrefix = "//" + uriPath;
        String mainContextPath = mainDeploymentInfo.getContextPath();
        boolean isRelativeUri = uriPath.startsWith(mainContextPath);
        String relativeUriPath = isRelativeUri ? uriPath.substring(mainContextPath.length()) : null;
        for (SecurityConstraint mainSecurityConstraint : mainDeploymentInfo.getSecurityConstraints()) {
            SecurityConstraint endpointSecurityConstraint = new SecurityConstraint();
            for (WebResourceCollection mainResourceCollection : mainSecurityConstraint.getWebResourceCollections()) {
                WebResourceCollection endpointResourceCollection = new WebResourceCollection();
                for (String mainUrlPattern : mainResourceCollection.getUrlPatterns()) {
                    if (MATCH_ALL_ENDPOINT_URI_PREFIX.equals(mainUrlPattern)) {
                        endpointResourceCollection.addUrlPattern(MATCH_ALL_PREFIX);
                        continue;
                    }
                    UrlPattern pattern = new UrlPattern(mainUrlPattern);
                    String relativePattern = null;
                    if (isRelativeUri) {
                        relativePattern = pattern.relativize(relativeUriPath);
                        if (relativePattern == null) continue;
                        endpointResourceCollection.addUrlPattern(relativePattern);
                        continue;
                    }
                    relativePattern = pattern.relativize(endpointUriPrefix);
                    if (relativePattern == null) continue;
                    endpointResourceCollection.addUrlPattern(relativePattern);
                }
                if (endpointResourceCollection.getUrlPatterns().isEmpty()) continue;
                endpointResourceCollection.addHttpMethods((Collection)mainResourceCollection.getHttpMethods());
                endpointResourceCollection.addHttpMethodOmissions((Collection)mainResourceCollection.getHttpMethodOmissions());
                endpointSecurityConstraint.addWebResourceCollection(endpointResourceCollection);
            }
            if (endpointSecurityConstraint.getWebResourceCollections().isEmpty()) continue;
            endpointSecurityConstraint.addRolesAllowed((Collection)mainSecurityConstraint.getRolesAllowed());
            endpointSecurityConstraint.setEmptyRoleSemantic(mainSecurityConstraint.getEmptyRoleSemantic());
            endpointSecurityConstraint.setTransportGuaranteeType(CamelEndpointDeployerService.transportGuaranteeType(uri, mainSecurityConstraint.getTransportGuaranteeType()));
            result.add(endpointSecurityConstraint);
        }
        if (result.isEmpty() && uri.getScheme().equals("https")) {
            WebResourceCollection webResourceCollection = new WebResourceCollection();
            webResourceCollection.addUrlPattern(MATCH_ALL_PREFIX);
            SecurityConstraint endpointSecurityConstraint = new SecurityConstraint();
            endpointSecurityConstraint.addWebResourceCollection(webResourceCollection);
            endpointSecurityConstraint.setTransportGuaranteeType(TransportGuaranteeType.CONFIDENTIAL);
            endpointSecurityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
            result.add(endpointSecurityConstraint);
        }
        return result;
    }

    static TransportGuaranteeType transportGuaranteeType(URI uri, TransportGuaranteeType transportGuaranteeType) {
        if (uri.getScheme().equals("https")) {
            return TransportGuaranteeType.CONFIDENTIAL;
        }
        if (transportGuaranteeType != null) {
            return transportGuaranteeType;
        }
        return TransportGuaranteeType.NONE;
    }

    public CamelEndpointDeployerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void deploy(URI uri, CamelEndpointDeploymentSchedulerService.EndpointHttpHandler endpointHttpHandler) {
        this.doDeploy(uri, servletInstance -> servletInstance.setEndpointHttpHandler(endpointHttpHandler), deploymentInfo -> {}, deployment -> {});
    }

    public void deploy(URI uri, HttpHandler routingHandler) {
        Set availableDeployments = ((Host)this.hostSupplier.getValue()).getDeployments();
        if (!availableDeployments.stream().anyMatch(deployment -> deployment.getHandler() instanceof CamelEndpointDeployerHandler && ((CamelEndpointDeployerHandler)deployment.getHandler()).getRoutingHandler() == routingHandler)) {
            this.doDeploy(uri, servletInstance -> servletInstance.setEndpointHttpHandler(new DelegatingEndpointHttpHandler(routingHandler)), deploymentInfo -> deploymentInfo.addInnerHandlerChainWrapper(exchangeStoringHandlerWrapper), deployment -> {
                CamelEndpointDeployerHandler servletHandler = new CamelEndpointDeployerHandler(deployment.getHandler(), routingHandler);
                deployment.setInitialHandler((HttpHandler)servletHandler);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDeploy(URI uri, Consumer<EndpointServlet> endpointServletConsumer, Consumer<DeploymentInfo> deploymentInfoConsumer, Consumer<DeploymentImpl> deploymentConsumer) {
        ServletInfo servletInfo = Servlets.servlet((String)"EndpointServlet", EndpointServlet.class).addMapping(MATCH_ALL_PREFIX).setAsyncSupported(true);
        DeploymentInfo mainDeploymentInfo = (DeploymentInfo)this.deploymentInfoSupplier.getValue();
        DeploymentInfo endPointDeplyomentInfo = CamelEndpointDeployerService.adaptDeploymentInfo(mainDeploymentInfo, uri, servletInfo);
        deploymentInfoConsumer.accept(endPointDeplyomentInfo);
        CamelLogger.LOGGER.debug("Deploying endpoint {}", (Object)endPointDeplyomentInfo.getDeploymentName());
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(endPointDeplyomentInfo.getClassLoader());
        try {
            DeploymentManager manager = ((ServletContainerService)this.servletContainerServiceSupplier.getValue()).getServletContainer().addDeployment(endPointDeplyomentInfo);
            manager.deploy();
            Deployment deployment = manager.getDeployment();
            try {
                deploymentConsumer.accept((DeploymentImpl)deployment);
                manager.start();
                ((Host)this.hostSupplier.getValue()).registerDeployment(deployment, deployment.getHandler());
                ManagedServlet managedServlet = deployment.getServlets().getManagedServlet("EndpointServlet");
                EndpointServlet servletInstance = (EndpointServlet)((Object)managedServlet.getServlet().getInstance());
                endpointServletConsumer.accept(servletInstance);
            }
            catch (ServletException ex) {
                throw new IllegalStateException(ex);
            }
            Map<URI, DeploymentManager> map = this.deployments;
            synchronized (map) {
                this.deployments.put(uri, manager);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void start(StartContext context) throws StartException {
        ((CamelEndpointDeploymentSchedulerService)this.deploymentSchedulerServiceSupplier.getValue()).registerDeployer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        Map<URI, DeploymentManager> map = this.deployments;
        synchronized (map) {
            for (DeploymentManager deploymentManager : this.deployments.values()) {
                this.undeploy(deploymentManager);
            }
            this.deployments.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(URI uri) {
        Map<URI, DeploymentManager> map = this.deployments;
        synchronized (map) {
            DeploymentManager deploymentManager = this.deployments.remove(uri);
            if (deploymentManager != null) {
                try {
                    this.undeploy(deploymentManager);
                }
                catch (IllegalStateException e) {
                    CamelLogger.LOGGER.warn("Could not undeploy endpoint " + deploymentManager.getDeployment().getDeploymentInfo().getDeploymentName(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeploy(DeploymentManager deploymentManager) {
        Deployment deployment = deploymentManager.getDeployment();
        CamelLogger.LOGGER.debug("Undeploying endpoint {}", (Object)deployment.getDeploymentInfo().getDeploymentName());
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(deployment.getDeploymentInfo().getClassLoader());
        try {
            try {
                ((Host)this.hostSupplier.getValue()).unregisterDeployment(deployment);
                deploymentManager.stop();
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
            deploymentManager.undeploy();
            ((ServletContainerService)this.servletContainerServiceSupplier.getValue()).getServletContainer().removeDeployment(deployment.getDeploymentInfo());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    static class UrlPattern {
        private final String source;

        public UrlPattern(String source) {
            this.source = source;
        }

        public String relativize(String path) {
            StringTokenizer patternTokenizer = new StringTokenizer(this.source, "/", true);
            StringTokenizer pathTokenizer = new StringTokenizer(path, "/", true);
            while (pathTokenizer.hasMoreTokens()) {
                if (!patternTokenizer.hasMoreTokens()) {
                    return null;
                }
                String patternToken = patternTokenizer.nextToken();
                String pathToken = pathTokenizer.nextToken();
                boolean isSlash = patternToken.equals("/");
                if (isSlash != pathToken.equals("/")) {
                    return null;
                }
                if (isSlash || "*".equals(pathToken)) continue;
                StringTokenizer segmentTokenizer = new StringTokenizer(patternToken, "*", true);
                StringBuilder segmentPatternBuilder = new StringBuilder(patternToken.length());
                while (segmentTokenizer.hasMoreTokens()) {
                    String segmentToken = segmentTokenizer.nextToken();
                    if ("*".equals(segmentToken)) {
                        segmentPatternBuilder.append(".*");
                        continue;
                    }
                    segmentPatternBuilder.append(Pattern.quote(segmentToken));
                }
                Pattern pat = Pattern.compile(segmentPatternBuilder.toString());
                if (pat.matcher(pathToken).matches()) continue;
                return null;
            }
            StringBuilder result = new StringBuilder();
            while (patternTokenizer.hasMoreTokens()) {
                result.append(patternTokenizer.nextToken());
            }
            if (result.length() == 0) {
                return "";
            }
            if (result.charAt(0) != '/') {
                return "/" + result.toString();
            }
            return result.toString();
        }
    }

    static class EndpointServlet
    extends HttpServlet {
        public static final String NAME = "EndpointServlet";
        private CamelEndpointDeploymentSchedulerService.EndpointHttpHandler endpointHttpHandler;

        EndpointServlet() {
        }

        protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            if (this.endpointHttpHandler != null) {
                this.endpointHttpHandler.service(this.getServletContext(), req, res);
            }
        }

        public void setEndpointHttpHandler(CamelEndpointDeploymentSchedulerService.EndpointHttpHandler endpointHttpHandler) {
            this.endpointHttpHandler = endpointHttpHandler;
        }
    }

    static class DelegatingEndpointHttpHandler
    implements CamelEndpointDeploymentSchedulerService.EndpointHttpHandler {
        private final HttpHandler handler;

        public DelegatingEndpointHttpHandler(HttpHandler handler) {
            this.handler = handler;
        }

        @Override
        public ClassLoader getClassLoader() {
            return null;
        }

        @Override
        public void service(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            HttpServerExchange exchange = (HttpServerExchange)exchangeThreadLocal.get();
            try {
                this.handler.handleRequest(exchange);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class CamelEndpointDeployerHandler
    implements HttpHandler {
        private final HttpHandler initialServletHandler;
        private final HttpHandler routingHandler;

        public CamelEndpointDeployerHandler(HttpHandler initialServletHandler, HttpHandler routingHandler) {
            this.initialServletHandler = initialServletHandler;
            this.routingHandler = routingHandler;
        }

        public HttpHandler getRoutingHandler() {
            return this.routingHandler;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            this.initialServletHandler.handleRequest(exchange);
        }
    }
}

