/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.handler.CamelNamespaceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.wildfly.camel.proxy.ProxiedAction;
import org.wildfly.camel.proxy.ProxyUtils;

public class SpringCamelContextBootstrap {
    private static Logger LOGGER = LoggerFactory.getLogger(SpringCamelContextBootstrap.class);
    private GenericApplicationContext applicationContext;

    public SpringCamelContextBootstrap(URL contextUrl, ClassLoader classLoader) {
        this((Resource)new UrlResource(contextUrl), classLoader);
    }

    public SpringCamelContextBootstrap(byte[] bytes, ClassLoader classLoader) {
        this((Resource)new ByteArrayResource(bytes), classLoader);
    }

    private SpringCamelContextBootstrap(Resource resource, ClassLoader classLoader) {
        this.loadBeanDefinitions(resource, classLoader);
    }

    public List<SpringCamelContext> createSpringCamelContexts() throws Exception {
        if (this.applicationContext.isActive()) {
            throw new IllegalStateException("Unable to refresh Spring application context. Context is already initialized");
        }
        SpringCamelContext.setNoStart((boolean)true);
        ProxyUtils.invokeProxied((ProxiedAction)new ProxiedAction(){

            public void run() throws Exception {
                SpringCamelContextBootstrap.this.applicationContext.refresh();
            }
        }, (ClassLoader)this.applicationContext.getClassLoader());
        SpringCamelContext.setNoStart((boolean)false);
        return this.getSpringCamelContexts();
    }

    public List<SpringCamelContext> getSpringCamelContexts() {
        ArrayList<Object> beans = new ArrayList<Object>();
        for (String name : this.applicationContext.getBeanNamesForType(SpringCamelContext.class)) {
            beans.add(this.applicationContext.getBean(name, SpringCamelContext.class));
        }
        return Collections.unmodifiableList(beans);
    }

    public List<String> getJndiNames() {
        ArrayList<String> bindings = new ArrayList<String>();
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            BeanDefinition definition = this.applicationContext.getBeanDefinition(beanName);
            String beanClassName = definition.getBeanClassName();
            if (beanClassName == null || !beanClassName.equals(JndiObjectFactoryBean.class.getName())) continue;
            MutablePropertyValues propertyValues = definition.getPropertyValues();
            Object jndiPropertyValue = propertyValues.get("jndiName");
            if (jndiPropertyValue == null) {
                LOGGER.debug("Skipping JNDI binding dependency for bean: {}", (Object)beanName);
                continue;
            }
            String jndiName = null;
            if (jndiPropertyValue instanceof String) {
                jndiName = (String)jndiPropertyValue;
            } else if (jndiPropertyValue instanceof TypedStringValue) {
                jndiName = ((TypedStringValue)jndiPropertyValue).getValue();
            } else {
                LOGGER.debug("Ignoring unknown JndiObjectFactoryBean property value type {}", (Object)jndiPropertyValue.getClass().getSimpleName());
            }
            if (jndiName == null) continue;
            bindings.add(jndiName);
        }
        return Collections.unmodifiableList(bindings);
    }

    public ClassLoader getClassLoader() {
        return this.applicationContext.getClassLoader();
    }

    private void loadBeanDefinitions(Resource resource, ClassLoader classLoader) {
        this.applicationContext = new GenericApplicationContext();
        this.applicationContext.setClassLoader(classLoader);
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.applicationContext){

            protected NamespaceHandlerResolver createDefaultNamespaceHandlerResolver() {
                NamespaceHandlerResolver defaultResolver = super.createDefaultNamespaceHandlerResolver();
                return new CamelNamespaceHandlerResolver(defaultResolver);
            }
        };
        xmlReader.loadBeanDefinitions(resource);
    }

    private static class CamelNamespaceHandlerResolver
    implements NamespaceHandlerResolver {
        private final NamespaceHandlerResolver delegate;
        private final NamespaceHandler camelHandler;

        CamelNamespaceHandlerResolver(NamespaceHandlerResolver delegate) {
            this.delegate = delegate;
            this.camelHandler = new CamelNamespaceHandler();
            this.camelHandler.init();
        }

        public NamespaceHandler resolve(String namespaceUri) {
            if ("http://camel.apache.org/schema/spring".equals(namespaceUri)) {
                return this.camelHandler;
            }
            return this.delegate.resolve(namespaceUri);
        }
    }
}

