/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

public final class CamelDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final String APACHE_CAMEL_MODULE = "org.apache.camel";
    private static final String APACHE_CAMEL_COMPONENT_MODULE = "org.apache.camel.component";
    private static final String APACHE_CAMEL_COMPONENT_CDI_MODULE = "org.apache.camel.component.cdi";
    private static final String WILDFLY_CAMEL_MODULE = "org.wildfly.extension.camel";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        if (depUnit.getParent() != null) {
            return;
        }
        ArrayList<DeploymentUnit> deployments = new ArrayList<DeploymentUnit>();
        List subDeployments = depUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        deployments.add(depUnit);
        deployments.addAll(subDeployments);
        for (DeploymentUnit deployment : deployments) {
            CamelDeploymentSettings depSettings = (CamelDeploymentSettings)deployment.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
            if (!depSettings.isEnabled()) continue;
            this.addDeploymentDependencies(deployment, depSettings);
        }
    }

    private void addDeploymentDependencies(DeploymentUnit depUnit, CamelDeploymentSettings depSettings) {
        ModuleLoader moduleLoader = (ModuleLoader)depUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ModuleSpecification moduleSpec = (ModuleSpecification)depUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)WILDFLY_CAMEL_MODULE), false, false, false, false));
        ModuleDependency moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)APACHE_CAMEL_MODULE), false, false, true, false);
        moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
        moduleSpec.addUserDependency(moddep);
        List<String> deploymentDefinedModules = depSettings.getModuleDependencies();
        if (!deploymentDefinedModules.isEmpty()) {
            for (String modid : deploymentDefinedModules) {
                moduleSpec.addUserDependency(new ModuleDependency(moduleLoader, modid, false, false, true, false));
            }
        } else {
            moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)APACHE_CAMEL_COMPONENT_MODULE), false, false, true, false);
            moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
            moddep.addImportFilter(PathFilters.isOrIsChildOf((String)"META-INF/cxf"), true);
            moduleSpec.addUserDependency(moddep);
            moddep = new ModuleDependency(moduleLoader, ModuleIdentifier.create((String)APACHE_CAMEL_COMPONENT_CDI_MODULE), true, false, false, false);
            moddep.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
            moddep.addImportFilter(PathFilters.getMetaInfFilter(), true);
            moduleSpec.addUserDependency(moddep);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

