/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.security.AccessController;
import org.wildfly.security.manager.action.GetClassLoaderAction;
import org.wildfly.security.manager.action.GetContextClassLoaderAction;
import org.wildfly.security.manager.action.ReadPropertyAction;
import org.wildfly.security.manager.action.SetContextClassLoaderAction;
import org.wildfly.security.manager.action.WritePropertyAction;

class SecurityActions {
    private SecurityActions() {
    }

    static String getSystemProperty(String key, String defaultValue) {
        return System.getSecurityManager() == null ? System.getProperty(key, defaultValue) : (String)AccessController.doPrivileged(new ReadPropertyAction(key, defaultValue));
    }

    static String setSystemProperty(String key, String value) {
        return System.getSecurityManager() == null ? System.setProperty(key, value) : (String)AccessController.doPrivileged(new WritePropertyAction(key, value));
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        return System.getSecurityManager() == null ? clazz.getClassLoader() : (ClassLoader)AccessController.doPrivileged(new GetClassLoaderAction(clazz));
    }

    static ClassLoader getContextClassLoader() {
        return System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : (ClassLoader)AccessController.doPrivileged(GetContextClassLoaderAction.getInstance());
    }

    static void setContextClassLoader(ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new SetContextClassLoaderAction(classLoader));
        }
    }
}

