/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import io.undertow.server.HttpHandler;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.service.CamelEndpointDeployerService;
import org.wildfly.extension.camel.service.SecurityActions;

public class CamelEndpointDeploymentSchedulerService
implements Service<CamelEndpointDeploymentSchedulerService> {
    private static final String SERVICE_NAME = "EndpointDeploymentScheduler";
    private static final String EAR_INFIX = ".ear.";
    private static final String DEPLOYMENT_CL_NAME_PREFIX = "deployment.";
    private static final String WAR_SUFFIX = ".war";
    private volatile CamelEndpointDeployerService deployerService;
    private final String deploymentName;
    private final Map<URI, Object> scheduledHandlers = new HashMap<URI, Object>();

    public static ServiceController<CamelEndpointDeploymentSchedulerService> addService(ServiceName deploymentUnitServiceName, String deploymentName, ServiceTarget serviceTarget) {
        CamelEndpointDeploymentSchedulerService service = new CamelEndpointDeploymentSchedulerService(deploymentName);
        return serviceTarget.addService(CamelEndpointDeploymentSchedulerService.deploymentSchedulerServiceName(deploymentUnitServiceName), (Service)service).install();
    }

    public static ServiceName deploymentSchedulerServiceName(ClassLoader deploymentClassLoader) {
        if (deploymentClassLoader == null) {
            deploymentClassLoader = SecurityActions.getContextClassLoader();
        }
        if (deploymentClassLoader instanceof ModuleClassLoader) {
            ModuleClassLoader moduleClassLoader = (ModuleClassLoader)deploymentClassLoader;
            String clName = moduleClassLoader.getName();
            if (clName.startsWith(DEPLOYMENT_CL_NAME_PREFIX)) {
                if (clName.endsWith(WAR_SUFFIX)) {
                    String deploymentName = clName.substring(DEPLOYMENT_CL_NAME_PREFIX.length());
                    int earInfixPos = deploymentName.indexOf(EAR_INFIX);
                    if (earInfixPos >= 0) {
                        String earName = deploymentName.substring(0, earInfixPos + EAR_INFIX.length() - 1);
                        String warName = deploymentName.substring(earInfixPos + EAR_INFIX.length());
                        return ServiceName.of((String[])new String[]{"jboss", "deployment", "subunit", earName, warName, SERVICE_NAME});
                    }
                    return ServiceName.of((String[])new String[]{"jboss", "deployment", "unit", deploymentName, SERVICE_NAME});
                }
                throw new IllegalStateException(String.format("Expected a %s name ending with '%s'; found %s", ModuleClassLoader.class.getName(), WAR_SUFFIX, clName));
            }
            throw new IllegalStateException(String.format("Expected a %s name starting with '%s'; found %s", ModuleClassLoader.class.getName(), DEPLOYMENT_CL_NAME_PREFIX, clName));
        }
        throw new IllegalStateException(String.format("Expected a %s; found %s", ModuleClassLoader.class.getName(), deploymentClassLoader));
    }

    public static ServiceName deploymentSchedulerServiceName(ServiceName deploymentUnitServiceName) {
        return deploymentUnitServiceName.append(new String[]{SERVICE_NAME});
    }

    CamelEndpointDeploymentSchedulerService(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public CamelEndpointDeploymentSchedulerService getValue() throws IllegalStateException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(URI uri, EndpointHttpHandler endpointHttpHandler) {
        Map<URI, Object> map = this.scheduledHandlers;
        synchronized (map) {
            CamelLogger.LOGGER.debug("Scheduling a deployment of endpoint {} from {}", (Object)uri, (Object)this.deploymentName);
            if (this.deployerService != null) {
                this.deployerService.deploy(uri, endpointHttpHandler);
            } else {
                this.scheduledHandlers.put(uri, endpointHttpHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(URI uri, HttpHandler handler) {
        Map<URI, Object> map = this.scheduledHandlers;
        synchronized (map) {
            CamelLogger.LOGGER.debug("Scheduling a deployment of endpoint {} from {}", (Object)uri, (Object)this.deploymentName);
            if (this.deployerService != null) {
                this.deployerService.deploy(uri, handler);
            } else {
                this.scheduledHandlers.put(uri, handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDeployer(CamelEndpointDeployerService deploymentService) {
        Map<URI, Object> map = this.scheduledHandlers;
        synchronized (map) {
            Iterator<Map.Entry<URI, Object>> it = this.scheduledHandlers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<URI, Object> en = it.next();
                Object handler = en.getValue();
                if (handler instanceof EndpointHttpHandler) {
                    deploymentService.deploy(en.getKey(), (EndpointHttpHandler)handler);
                } else if (handler instanceof HttpHandler) {
                    deploymentService.deploy(en.getKey(), (HttpHandler)handler);
                } else {
                    throw new IllegalStateException("Unexpected type " + (handler == null ? "null" : handler.getClass().getName()));
                }
                it.remove();
            }
            this.deployerService = deploymentService;
        }
    }

    public void start(StartContext context) throws StartException {
        CamelLogger.LOGGER.debug("{} started for deployment {}", (Object)CamelEndpointDeploymentSchedulerService.class.getSimpleName(), (Object)this.deploymentName);
    }

    public void stop(StopContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unschedule(URI uri) {
        Map<URI, Object> map = this.scheduledHandlers;
        synchronized (map) {
            CamelLogger.LOGGER.debug("Unscheduling a deployment of endpoint {} from {}", (Object)uri, (Object)this.deploymentName);
            if (this.deployerService != null) {
                this.deployerService.undeploy(uri);
            } else {
                this.scheduledHandlers.remove(uri);
            }
        }
    }

    public static interface EndpointHttpHandler {
        public ClassLoader getClassLoader();

        public void service(ServletContext var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException;
    }
}

