/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.wildfly.camel.utils.IllegalStateAssertion;

public class EndpointRegistryClient {
    private final ModelControllerClient controllerClient;

    public EndpointRegistryClient(ModelControllerClient controllerClient) {
        this.controllerClient = controllerClient;
    }

    public List<URL> getRegisteredEndpoints(String pathFilter) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        ModelNode resnode = this.controllerClient.execute(this.createOpNode("subsystem=camel", "read-attribute(name=endpoints)"));
        IllegalStateAssertion.assertEquals((Object)"success", (Object)resnode.get("outcome").asString(), (String)"Cannot obtain endpoint URLs");
        for (ModelNode item : resnode.get("result").asList()) {
            if (pathFilter != null && !item.asString().endsWith(pathFilter)) continue;
            result.add(new URL(item.asString()));
        }
        return Collections.unmodifiableList(result);
    }

    private ModelNode createOpNode(String address, String operation) {
        Matcher matcher;
        ModelNode op = new ModelNode();
        ModelNode list = op.get("address").setEmptyList();
        if (address != null) {
            String[] pathSegments;
            for (String segment : pathSegments = address.split("/")) {
                String[] elements = segment.split("=");
                list.add(elements[0], elements[1]);
            }
        }
        if ((matcher = Pattern.compile(".*\\((.*?)\\)").matcher(operation)).matches()) {
            matcher.reset();
            op.get("operation").set(operation.substring(0, operation.indexOf(40)));
            while (matcher.find()) {
                String args = matcher.group(1);
                for (String argSegment : args.split(",")) {
                    String[] argElements = argSegment.split("=");
                    op.get(argElements[0].trim()).set(argElements[1].trim());
                }
            }
        } else {
            op.get("operation").set(operation);
        }
        return op;
    }
}

