/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.List;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.SpringCamelContextBootstrap;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;
import org.wildfly.extension.camel.service.CamelContextActivationService;

public class CamelContextActivationProcessor
implements DeploymentUnitProcessor {
    private static final ServiceName CAMEL_CONTEXT_ACTIVATION_SERVICE_NAME = ServiceName.of((String[])new String[]{"CamelContextActivationService"});

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (!depSettings.isEnabled()) {
            return;
        }
        String runtimeName = depUnit.getName();
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName camelActivationServiceName = depUnit.getServiceName().append(CAMEL_CONTEXT_ACTIVATION_SERVICE_NAME.append(new String[]{runtimeName}));
        List camelctxBootstrapList = depUnit.getAttachmentList(CamelConstants.CAMEL_CONTEXT_BOOTSTRAP_KEY);
        CamelContextActivationService activationService = new CamelContextActivationService(camelctxBootstrapList, runtimeName);
        ServiceBuilder builder = serviceTarget.addService(camelActivationServiceName, (Service)activationService);
        depUnit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)camelActivationServiceName);
        for (SpringCamelContextBootstrap bootstrap : camelctxBootstrapList) {
            for (String jndiName : bootstrap.getJndiNames()) {
                if (jndiName.startsWith("${")) {
                    CamelLogger.LOGGER.warn("Skipping JNDI binding dependency for property placeholder value: {}", (Object)jndiName);
                    continue;
                }
                CamelLogger.LOGGER.debug("Add CamelContextActivationService JNDI binding dependency for {}", (Object)jndiName);
                this.installBindingDependency(builder, jndiName);
            }
        }
        builder.install();
    }

    public void undeploy(DeploymentUnit depUnit) {
    }

    private void installBindingDependency(ServiceBuilder builder, String jndiName) {
        if (jndiName != null) {
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
            builder.addDependency(bindInfo.getBinderServiceName());
        }
    }
}

