/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.handler;

import java.util.Iterator;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.impl.engine.DefaultPackageScanClassResolver;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.Resource;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.ContextCreateHandler;

public final class PackageScanClassResolverAssociationHandler
implements ContextCreateHandler {
    private final ModuleClassLoader moduleClassLoader;

    public PackageScanClassResolverAssociationHandler(ModuleClassLoader moduleClassLoader) {
        this.moduleClassLoader = moduleClassLoader;
    }

    @Override
    public void setup(CamelContext camelctx) {
        PackageScanClassResolverImpl resolver = new PackageScanClassResolverImpl(this.moduleClassLoader);
        ((ExtendedCamelContext)camelctx).setPackageScanClassResolver((PackageScanClassResolver)resolver);
    }

    static final class PackageScanClassResolverImpl
    extends DefaultPackageScanClassResolver {
        PackageScanClassResolverImpl(ModuleClassLoader classLoader) {
            this.addClassLoader((ClassLoader)classLoader);
        }

        protected void find(PackageScanFilter filter, String packageName, ClassLoader classLoader, Set<Class<?>> classes) {
            CamelLogger.LOGGER.debug("Searching for: {} in package: {} using classloader: {}", new Object[]{filter, packageName, classLoader});
            if (!(classLoader instanceof ModuleClassLoader)) {
                super.find(filter, packageName, classLoader, classes);
                return;
            }
            int classLoadCount = classes.size();
            ModuleClassLoader moduleClassLoader = (ModuleClassLoader)classLoader;
            Iterator itres = moduleClassLoader.iterateResources("/", true);
            while (itres.hasNext()) {
                Resource resource = (Resource)itres.next();
                String resname = resource.getName();
                if (!resname.startsWith(packageName) || !resname.endsWith(".class")) continue;
                String className = resname.substring(0, resname.length() - 6).replace('/', '.');
                try {
                    Class loadedClass = moduleClassLoader.loadClass(className);
                    if (!filter.matches(loadedClass)) continue;
                    CamelLogger.LOGGER.debug("Found type in package scan: {}", (Object)loadedClass.getName());
                    classes.add(loadedClass);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (classes.size() == classLoadCount) {
                super.find(filter, packageName, classLoader, classes);
            }
        }
    }
}

