/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.ContextCreateHandlerRegistry;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;
import org.wildfly.extension.camel.handler.PackageScanClassResolverAssociationHandler;

public class PackageScanResolverProcessor
implements DeploymentUnitProcessor {
    private static final AttachmentKey<PackageScanClassResolverAssociationHandler> PACKAGE_SCAN_ASSOCIATION_HANDLER_ATTACHMENT_KEY = AttachmentKey.create(PackageScanClassResolverAssociationHandler.class);

    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (!depSettings.isEnabled()) {
            return;
        }
        ContextCreateHandlerRegistry createHandlerRegistry = (ContextCreateHandlerRegistry)depUnit.getAttachment(CamelConstants.CONTEXT_CREATE_HANDLER_REGISTRY_KEY);
        ModuleClassLoader moduleClassLoader = ((Module)depUnit.getAttachment(Attachments.MODULE)).getClassLoader();
        PackageScanClassResolverAssociationHandler contextCreateHandler = new PackageScanClassResolverAssociationHandler(moduleClassLoader);
        depUnit.putAttachment(PACKAGE_SCAN_ASSOCIATION_HANDLER_ATTACHMENT_KEY, (Object)contextCreateHandler);
        createHandlerRegistry.addContextCreateHandler((ClassLoader)moduleClassLoader, contextCreateHandler);
    }

    public void undeploy(DeploymentUnit depUnit) {
        ContextCreateHandler handler;
        ContextCreateHandlerRegistry createHandlerRegistry = (ContextCreateHandlerRegistry)depUnit.getAttachment(CamelConstants.CONTEXT_CREATE_HANDLER_REGISTRY_KEY);
        if (createHandlerRegistry != null && (handler = (ContextCreateHandler)depUnit.removeAttachment(PACKAGE_SCAN_ASSOCIATION_HANDLER_ATTACHMENT_KEY)) != null) {
            ModuleClassLoader classLoader = ((Module)depUnit.getAttachment(Attachments.MODULE)).getClassLoader();
            createHandlerRegistry.removeContextCreateHandler((ClassLoader)classLoader, handler);
        }
    }
}

