/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.parser;

import org.apache.camel.CamelContext;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.parser.SubsystemState;
import org.wildfly.extension.camel.service.CamelContextRegistryService;

final class CamelContextRemove
extends AbstractRemoveStepHandler {
    private final SubsystemState subsystemState;

    CamelContextRemove(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        CamelContextRegistryService serviceRegistry;
        CamelContextRegistryService.MutableCamelContextRegistry camelContextRegistry;
        final String propName = operation.get("address").asObject().get("context").asString();
        final String oldContextDefinition = this.subsystemState.removeContextDefinition(propName);
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                CamelContextRemove.this.subsystemState.putContextDefinition(propName, oldContextDefinition);
            }
        });
        ServiceController container = context.getServiceRegistry(false).getService(CamelConstants.CAMEL_CONTEXT_REGISTRY_SERVICE_NAME);
        if (container != null && (camelContextRegistry = (serviceRegistry = (CamelContextRegistryService)((Object)CamelContextRegistryService.class.cast(container.getService()))).getValue()) != null) {
            CamelContext camelctx = camelContextRegistry.getCamelContext(propName);
            try {
                if (camelctx != null) {
                    camelctx.close();
                }
            }
            catch (Exception e) {
                CamelLogger.LOGGER.warn("Cannot stop camel context: " + camelctx.getName(), (Throwable)e);
                throw new OperationFailedException((Throwable)e);
            }
        }
    }
}

