/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

public final class CamelDeploymentSettingsBuilderProcessor
implements DeploymentUnitProcessor {
    private static final String[] ACTIVATION_ANNOTATIONS = new String[]{"org.wildfly.extension.camel.CamelAware", "org.apache.camel.cdi.Uri", "org.apache.camel.cdi.ImportResource", "javax.inject.Inject", "javax.inject.Named", "javax.enterprise.context.ApplicationScoped", "javax.enterprise.inject.Produces"};
    private static final String CAMEL_PACKAGE_PREFIX = "org.apache.camel";

    public static String getDeploymentName(DeploymentUnit depUnit) {
        DeploymentUnit parent = depUnit.getParent();
        return parent != null ? parent.getName() + "." + depUnit.getName() : depUnit.getName();
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        CamelDeploymentSettings.Builder parentDepSettingsBuilder;
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings.Builder depSettingsBuilder = (CamelDeploymentSettings.Builder)depUnit.getAttachment(CamelDeploymentSettings.BUILDER_ATTACHMENT_KEY);
        if (depSettingsBuilder == null) {
            depSettingsBuilder = new CamelDeploymentSettings.Builder();
            depUnit.putAttachment(CamelDeploymentSettings.BUILDER_ATTACHMENT_KEY, (Object)depSettingsBuilder);
        } else if (depSettingsBuilder.isDisabledByJbossAll()) {
            return;
        }
        depSettingsBuilder.deploymentName(CamelDeploymentSettingsBuilderProcessor.getDeploymentName(depUnit));
        depSettingsBuilder.deploymentValid(this.isDeploymentValid(depUnit));
        depSettingsBuilder.camelActivationAnnotationPresent(this.hasCamelActivationAnnotations(depUnit));
        DeploymentUnit parentDepUnit = depUnit.getParent();
        if (parentDepUnit != null && (parentDepSettingsBuilder = (CamelDeploymentSettings.Builder)parentDepUnit.getAttachment(CamelDeploymentSettings.BUILDER_ATTACHMENT_KEY)) != null) {
            Consumer<CamelDeploymentSettings> consumer = ds -> {
                depUnit.removeAttachment(CamelDeploymentSettings.BUILDER_ATTACHMENT_KEY);
                depUnit.putAttachment(CamelDeploymentSettings.ATTACHMENT_KEY, ds);
            };
            parentDepSettingsBuilder.child(depSettingsBuilder, consumer);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }

    private boolean isDeploymentValid(DeploymentUnit depUnit) {
        boolean result = true;
        String runtimeName = depUnit.getName();
        if (runtimeName.startsWith("hawtio") && runtimeName.endsWith(".war") || runtimeName.endsWith(".rar")) {
            result = false;
        }
        return result;
    }

    private boolean hasCamelActivationAnnotations(DeploymentUnit depUnit) {
        boolean result = false;
        block0: for (String annotationClassName : ACTIVATION_ANNOTATIONS) {
            if (annotationClassName.equals("org.wildfly.extension.camel.CamelAware")) {
                AnnotationInstance annotation = this.getAnnotation(depUnit, annotationClassName);
                if (annotation == null) continue;
                CamelLogger.LOGGER.debug("@CamelAware annotation found");
                AnnotationValue value = annotation.value();
                boolean bl = result = value != null ? value.asBoolean() : true;
                if (!result) continue;
                break;
            }
            List<AnnotationInstance> annotations = this.getAnnotations(depUnit, annotationClassName);
            if (annotations.isEmpty()) continue;
            if (annotationClassName.startsWith("org.apache.camel.cdi")) {
                CamelLogger.LOGGER.debug("{} Camel CDI annotation found", (Object)annotations.get(0).toString(true));
                result = true;
                break;
            }
            for (AnnotationInstance instance : annotations) {
                if (!this.annotationTargetIsCamelApi(instance.target())) continue;
                CamelLogger.LOGGER.debug("{} annotation {} found on Camel API", (Object)instance.target().kind(), (Object)instance.name());
                result = true;
                continue block0;
            }
        }
        return result;
    }

    private boolean annotationTargetIsCamelApi(AnnotationTarget target) {
        if (target != null) {
            if (target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) {
                ClassInfo classInfo = target.asClass();
                if (this.isCamelApi(classInfo.name())) {
                    return false;
                }
                Type superType = classInfo.superClassType();
                if (superType != null && this.isCamelApi(superType.name())) {
                    return true;
                }
                return classInfo.interfaceNames().stream().anyMatch(interfaceName -> this.isCamelApi((DotName)interfaceName));
            }
            if (target.kind().equals((Object)AnnotationTarget.Kind.FIELD)) {
                FieldInfo fieldInfo = target.asField();
                return !this.isCamelApi(fieldInfo.declaringClass().name()) && this.isCamelApi(fieldInfo.type().name());
            }
            if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
                MethodInfo methodInfo = target.asMethod();
                return !this.isCamelApi(methodInfo.declaringClass().name()) && this.isCamelApi(methodInfo.returnType().name());
            }
        }
        return false;
    }

    private List<AnnotationInstance> getAnnotations(DeploymentUnit depUnit, String className) {
        CompositeIndex index = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        return index.getAnnotations(DotName.createSimple((String)className));
    }

    private AnnotationInstance getAnnotation(DeploymentUnit depUnit, String className) {
        List<AnnotationInstance> annotations = this.getAnnotations(depUnit, className);
        if (annotations.size() > 1) {
            CamelLogger.LOGGER.warn("Multiple annotations found: {}", annotations);
        }
        return annotations.size() > 0 ? annotations.get(0) : null;
    }

    private boolean isCamelApi(DotName name) {
        return name.toString().startsWith(CAMEL_PACKAGE_PREFIX);
    }
}

