/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelSubsytemExtension;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.ContextCreateHandlerRegistry;
import org.wildfly.extension.camel.handler.ClassResolverAssociationHandler;
import org.wildfly.extension.camel.handler.ComponentResolverAssociationHandler;
import org.wildfly.extension.camel.handler.ContextValidationHandler;
import org.wildfly.extension.camel.handler.ModelJAXBContextFactoryWrapperHandler;
import org.wildfly.extension.camel.handler.ModuleClassLoaderAssociationHandler;
import org.wildfly.extension.camel.parser.CamelSubsystemAdd;
import org.wildfly.extension.camel.parser.SubsystemRuntimeState;
import org.wildfly.extension.gravia.GraviaConstants;

public class ContextCreateHandlerRegistryService
extends AbstractService<ContextCreateHandlerRegistry> {
    private final SubsystemRuntimeState runtimeState;
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private ContextCreateHandlerRegistry createHandlerRegistry;

    public static ServiceController<ContextCreateHandlerRegistry> addService(ServiceTarget serviceTarget, SubsystemRuntimeState runtimeState) {
        ContextCreateHandlerRegistryService service = new ContextCreateHandlerRegistryService(runtimeState);
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CONTEXT_CREATE_HANDLER_REGISTRY_SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, service.injectedRuntime);
        return builder.install();
    }

    private ContextCreateHandlerRegistryService(SubsystemRuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    public void start(StartContext startContext) throws StartException {
        ServiceContainer serviceContainer = startContext.getController().getServiceContainer();
        this.createHandlerRegistry = new ContextCreateHandlerRegistryImpl(serviceContainer, startContext.getChildTarget());
    }

    public ContextCreateHandlerRegistry getValue() {
        return this.createHandlerRegistry;
    }

    final class ContextCreateHandlerRegistryImpl
    implements ContextCreateHandlerRegistry {
        private final Map<ClassLoader, List<ContextCreateHandler>> handlerMapping = new HashMap<ClassLoader, List<ContextCreateHandler>>();

        ContextCreateHandlerRegistryImpl(final ServiceContainer serviceContainer, final ServiceTarget serviceTarget) {
            this.addContextCreateHandler(null, new ModuleClassLoaderAssociationHandler());
            this.addContextCreateHandler(null, new ClassResolverAssociationHandler());
            this.addContextCreateHandler(null, new ComponentResolverAssociationHandler(ContextCreateHandlerRegistryService.this.runtimeState));
            this.addContextCreateHandler(null, new ModelJAXBContextFactoryWrapperHandler());
            this.addContextCreateHandler(null, new ContextValidationHandler());
            CamelSubsystemAdd.processExtensions(new Consumer<CamelSubsytemExtension>(){

                @Override
                public void accept(CamelSubsytemExtension plugin) {
                    ContextCreateHandler handler = plugin.getContextCreateHandler(serviceContainer, serviceTarget, ContextCreateHandlerRegistryService.this.runtimeState);
                    if (handler != null) {
                        ContextCreateHandlerRegistryImpl.this.addContextCreateHandler(null, handler);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ContextCreateHandler> getContextCreateHandlers(ClassLoader classsLoader) {
            ArrayList<ContextCreateHandler> result = new ArrayList<ContextCreateHandler>();
            Map<ClassLoader, List<ContextCreateHandler>> map = this.handlerMapping;
            synchronized (map) {
                List<ContextCreateHandler> handlers = this.handlerMapping.get(classsLoader);
                if (handlers != null) {
                    result.addAll(handlers);
                }
            }
            return Collections.unmodifiableList(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addContextCreateHandler(ClassLoader classsLoader, ContextCreateHandler handler) {
            Map<ClassLoader, List<ContextCreateHandler>> map = this.handlerMapping;
            synchronized (map) {
                List<ContextCreateHandler> handlers = this.handlerMapping.get(classsLoader);
                if (handlers == null) {
                    handlers = new ArrayList<ContextCreateHandler>();
                    this.handlerMapping.put(classsLoader, handlers);
                }
                handlers.add(handler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeContextCreateHandler(ClassLoader classsLoader, ContextCreateHandler handler) {
            Map<ClassLoader, List<ContextCreateHandler>> map = this.handlerMapping;
            synchronized (map) {
                List<ContextCreateHandler> handlers = this.handlerMapping.get(classsLoader);
                if (handlers != null) {
                    handlers.remove(handler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeContextCreateHandlers(ClassLoader classsLoader) {
            Map<ClassLoader, List<ContextCreateHandler>> map = this.handlerMapping;
            synchronized (map) {
                this.handlerMapping.remove(classsLoader);
            }
        }
    }
}

