/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.wildfly.extension.camel.CamelLogger;

public final class SubsystemRuntimeState {
    private final Set<URL> endpoints = new LinkedHashSet<URL>();
    private URL httpHost;

    public URL getHttpHost() {
        return this.httpHost;
    }

    public void setHttpHost(URL httpHost) {
        this.httpHost = httpHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URL> getEndpointURLs() {
        Set<URL> set = this.endpoints;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<URL>(this.endpoints));
        }
    }

    public void addHttpContext(String contextPath) {
        this.addEndpointURL(SubsystemRuntimeState.concatURL(this.httpHost, contextPath));
    }

    public boolean removeHttpContext(String contextPath) {
        return this.removeEndpointURL(SubsystemRuntimeState.concatURL(this.httpHost, contextPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndpointURL(URL endpointURL) {
        Set<URL> set = this.endpoints;
        synchronized (set) {
            CamelLogger.LOGGER.info("Add Camel endpoint: {}", (Object)endpointURL);
            this.endpoints.add(endpointURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEndpointURL(URL endpointURL) {
        Set<URL> set = this.endpoints;
        synchronized (set) {
            CamelLogger.LOGGER.info("Remove Camel endpoint: {}", (Object)endpointURL);
            return this.endpoints.remove(endpointURL);
        }
    }

    public static URL concatURL(URL hostURL, String contextPath) {
        URL endpointURL;
        try {
            endpointURL = new URL(hostURL + "" + contextPath);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        return endpointURL;
    }
}

