/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.handler;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.ComponentResolver;
import org.wildfly.extension.camel.CamelSubsytemExtension;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.parser.CamelSubsystemAdd;
import org.wildfly.extension.camel.parser.SubsystemRuntimeState;

public final class ComponentResolverAssociationHandler
implements ContextCreateHandler {
    private final SubsystemRuntimeState runtimeState;

    public ComponentResolverAssociationHandler(SubsystemRuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    @Override
    public void setup(CamelContext camelctx) {
        if (camelctx instanceof DefaultCamelContext) {
            DefaultCamelContext defaultctx = (DefaultCamelContext)camelctx;
            ComponentResolver delegate = defaultctx.getComponentResolver();
            defaultctx.setComponentResolver((ComponentResolver)new WildFlyComponentResolver(delegate));
        }
    }

    class WildFlyComponentResolver
    implements ComponentResolver {
        final ComponentResolver delegate;

        WildFlyComponentResolver(ComponentResolver delegate) {
            this.delegate = delegate;
        }

        public Component resolveComponent(String name, CamelContext context) throws Exception {
            Component component = null;
            ClassLoader classLoader = CamelSubsystemAdd.class.getClassLoader();
            Iterator<CamelSubsytemExtension> iterator = ServiceLoader.load(CamelSubsytemExtension.class, classLoader).iterator();
            while (iterator.hasNext() && component == null) {
                CamelSubsytemExtension plugin = iterator.next();
                component = plugin.resolveComponent(name, ComponentResolverAssociationHandler.this.runtimeState);
            }
            return component != null ? component : this.delegate.resolveComponent(name, context);
        }
    }
}

