/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.parser;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.camel.parser.Namespace;
import org.wildfly.extension.camel.parser.Namespace10;

final class CamelSubsystemParser
implements Namespace10,
XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    static XMLElementReader<List<ModelNode>> INSTANCE = new CamelSubsystemParser();

    private CamelSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "camel");
        address.protect();
        ModelNode subsystemAdd = new ModelNode();
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(address);
        operations.add(subsystemAdd);
        while (reader.hasNext() && reader.nextTag() != 2) {
            block0 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case VERSION_1_0: {
                    Namespace10.Element element = Namespace10.Element.forName(reader.getLocalName());
                    switch (element) {
                        case CAMEL_CONTEXT: {
                            this.parseCamelContext(reader, address, operations);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    private void parseCamelContext(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        String contextName = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String attrValue = reader.getAttributeValue(i);
            Namespace10.Attribute attribute = Namespace10.Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    contextName = attrValue;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (contextName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Namespace10.Attribute.ID));
        }
        StringBuffer content = new StringBuffer();
        while (reader.hasNext() && reader.next() != 2) {
            switch (reader.getEventType()) {
                case 4: 
                case 12: {
                    content.append(reader.getText());
                }
            }
        }
        String contextContent = content.toString();
        ModelNode propNode = new ModelNode();
        propNode.get("operation").set("add");
        propNode.get("address").set(address).add("context", contextName);
        propNode.get("value").set(contextContent);
        operations.add(propNode);
    }
}

