/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.handler;

import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.ComponentResolver;
import org.wildfly.extension.camel.CamelSubsytemExtension;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.parser.SubsystemState;

public final class ComponentResolverAssociationHandler
implements ContextCreateHandler {
    private final SubsystemState subsystemState;

    public ComponentResolverAssociationHandler(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    @Override
    public void setup(CamelContext camelctx) {
        if (camelctx instanceof DefaultCamelContext) {
            DefaultCamelContext defaultctx = (DefaultCamelContext)camelctx;
            ComponentResolver delegate = defaultctx.getComponentResolver();
            defaultctx.setComponentResolver((ComponentResolver)new WildFlyComponentResolver(delegate));
        }
    }

    class WildFlyComponentResolver
    implements ComponentResolver {
        final ComponentResolver delegate;

        WildFlyComponentResolver(ComponentResolver delegate) {
            this.delegate = delegate;
        }

        public Component resolveComponent(String name, CamelContext context) throws Exception {
            Component component = null;
            Iterator<CamelSubsytemExtension> iterator = ComponentResolverAssociationHandler.this.subsystemState.getCamelSubsytemExtensions().iterator();
            while (iterator.hasNext() && component == null) {
                CamelSubsytemExtension plugin = iterator.next();
                component = plugin.resolveComponent(name, ComponentResolverAssociationHandler.this.subsystemState);
            }
            return component != null ? component : this.delegate.resolveComponent(name, context);
        }
    }
}

