/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.CamelSubsytemExtension;

public final class SubsystemState {
    private final Map<String, String> contextDefinitions = new HashMap<String, String>();
    private final List<CamelSubsytemExtension> extensions = new ArrayList<CamelSubsytemExtension>();
    private final RuntimeState runtimeState = new RuntimeState();

    public SubsystemState() {
        ClassLoader classLoader = SubsystemState.class.getClassLoader();
        Iterator<CamelSubsytemExtension> it = ServiceLoader.load(CamelSubsytemExtension.class, classLoader).iterator();
        while (it.hasNext()) {
            this.extensions.add(it.next());
        }
    }

    public RuntimeState getRuntimeState() {
        return this.runtimeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getContextDefinitionNames() {
        Map<String, String> map = this.contextDefinitions;
        synchronized (map) {
            return this.contextDefinitions.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContextDefinition(String name) {
        Map<String, String> map = this.contextDefinitions;
        synchronized (map) {
            return this.contextDefinitions.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContextDefinition(String name, String contextDefinition) {
        Map<String, String> map = this.contextDefinitions;
        synchronized (map) {
            this.contextDefinitions.put(name, contextDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeContextDefinition(String name) {
        Map<String, String> map = this.contextDefinitions;
        synchronized (map) {
            return this.contextDefinitions.remove(name);
        }
    }

    public List<CamelSubsytemExtension> getCamelSubsytemExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public void processExtensions(Consumer<CamelSubsytemExtension> consumer) {
        this.extensions.iterator().forEachRemaining(consumer);
    }

    public static final class RuntimeState {
        private final Set<URL> endpoints = new LinkedHashSet<URL>();
        private URL httpHost;

        public URL getHttpHost() {
            return this.httpHost;
        }

        public void setHttpHost(URL httpHost) {
            this.httpHost = httpHost;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<URL> getEndpointURLs() {
            Set<URL> set = this.endpoints;
            synchronized (set) {
                return Collections.unmodifiableList(new ArrayList<URL>(this.endpoints));
            }
        }

        public void addHttpContext(String contextPath) {
            this.addEndpointURL(RuntimeState.concatURL(this.httpHost, contextPath));
        }

        public boolean removeHttpContext(String contextPath) {
            return this.removeEndpointURL(RuntimeState.concatURL(this.httpHost, contextPath));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEndpointURL(URL endpointURL) {
            Set<URL> set = this.endpoints;
            synchronized (set) {
                CamelLogger.LOGGER.info("Add Camel endpoint: {}", (Object)endpointURL);
                this.endpoints.add(endpointURL);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeEndpointURL(URL endpointURL) {
            Set<URL> set = this.endpoints;
            synchronized (set) {
                CamelLogger.LOGGER.info("Remove Camel endpoint: {}", (Object)endpointURL);
                return this.endpoints.remove(endpointURL);
            }
        }

        public static URL concatURL(URL hostURL, String contextPath) {
            URL endpointURL;
            try {
                endpointURL = new URL(hostURL + "" + contextPath);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
            return endpointURL;
        }
    }
}

