/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

public final class CamelDeploymentSettingsProcessor
implements DeploymentUnitProcessor {
    private static Map<String, CamelDeploymentSettings> deploymentSettingsMap = new HashMap<String, CamelDeploymentSettings>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CamelDeploymentSettings getDeploymentSettings(String name) {
        Map<String, CamelDeploymentSettings> map = deploymentSettingsMap;
        synchronized (map) {
            return deploymentSettingsMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String parentDeploymentName;
        CamelDeploymentSettings parentDepSettings;
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (depSettings == null) {
            depSettings = new CamelDeploymentSettings();
            depUnit.putAttachment(CamelDeploymentSettings.ATTACHMENT_KEY, (Object)depSettings);
        } else if (depSettings.isDisabledByJbossAll()) {
            return;
        }
        depSettings.setDeploymentValid(this.isDeploymentValid(depUnit));
        depSettings.setCamelAnnotationPresent(this.hasCamelActivationAnnotations(depUnit));
        Map<String, CamelDeploymentSettings> map = deploymentSettingsMap;
        synchronized (map) {
            deploymentSettingsMap.put(this.getDeploymentName(depUnit), depSettings);
        }
        DeploymentUnit parent = depUnit.getParent();
        if (parent != null && (parentDepSettings = CamelDeploymentSettingsProcessor.getDeploymentSettings(parentDeploymentName = this.getDeploymentName(parent))) != null) {
            parentDepSettings.addChild(depSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentUnit depUnit) {
        Map<String, CamelDeploymentSettings> map = deploymentSettingsMap;
        synchronized (map) {
            deploymentSettingsMap.remove(this.getDeploymentName(depUnit));
        }
    }

    private String getDeploymentName(DeploymentUnit depUnit) {
        DeploymentUnit parent = depUnit.getParent();
        return parent != null ? parent.getName() + "." + depUnit.getName() : depUnit.getName();
    }

    private boolean isDeploymentValid(DeploymentUnit depUnit) {
        boolean result = true;
        String runtimeName = depUnit.getName();
        if (runtimeName.startsWith("hawtio") && runtimeName.endsWith(".war") || runtimeName.endsWith(".rar")) {
            result = false;
        }
        return result;
    }

    private boolean hasCamelActivationAnnotations(DeploymentUnit depUnit) {
        List<AnnotationInstance> annotations;
        boolean result = false;
        AnnotationInstance annotation = this.getAnnotation(depUnit, "org.wildfly.extension.camel.CamelAware");
        if (annotation != null) {
            CamelLogger.LOGGER.debug("@CamelAware annotation found");
            AnnotationValue value = annotation.value();
            boolean bl = result = value != null ? value.asBoolean() : true;
        }
        if (!(annotations = this.getAnnotations(depUnit, "org.apache.camel.cdi.ContextName")).isEmpty()) {
            CamelLogger.LOGGER.debug("@ContextName annotation found");
            result = true;
        }
        if (!(annotations = this.getAnnotations(depUnit, "org.apache.camel.cdi.Uri")).isEmpty()) {
            CamelLogger.LOGGER.debug("@Uri annotation found");
            result = true;
        }
        return result;
    }

    private List<AnnotationInstance> getAnnotations(DeploymentUnit depUnit, String className) {
        CompositeIndex index = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        return index.getAnnotations(DotName.createSimple((String)className));
    }

    private AnnotationInstance getAnnotation(DeploymentUnit depUnit, String className) {
        List<AnnotationInstance> annotations = this.getAnnotations(depUnit, className);
        if (annotations.size() > 1) {
            CamelLogger.LOGGER.warn("Multiple annotations found: {}", annotations);
        }
        return annotations.size() > 0 ? annotations.get(0) : null;
    }
}

