/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.net.URL;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.SpringCamelContextBootstrap;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;

public class CamelContextBootstrapProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)depUnit.getAttachment(Attachments.MODULE);
        String runtimeName = depUnit.getName();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)depUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        for (URL contextURL : depSettings.getCamelContextUrls()) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)module.getClassLoader());
                SpringCamelContextBootstrap bootstrap = new SpringCamelContextBootstrap(contextURL, (ClassLoader)module.getClassLoader());
                depUnit.addToAttachmentList(CamelConstants.CAMEL_CONTEXT_BOOTSTRAP_KEY, (Object)bootstrap);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot create camel context: " + runtimeName, ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }
}

