/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.spring.SpringCamelContext;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.SpringCamelContextBootstrap;
import org.wildfly.extension.camel.proxy.ProxiedAction;
import org.wildfly.extension.camel.proxy.ProxyUtils;

public final class CamelContextActivationService
extends AbstractService<Void> {
    private final List<SpringCamelContextBootstrap> bootstraps;
    private final String runtimeName;

    public CamelContextActivationService(List<SpringCamelContextBootstrap> bootstraps, String runtimeName) {
        this.bootstraps = bootstraps;
        this.runtimeName = runtimeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        for (SpringCamelContextBootstrap bootstrap : this.bootstraps) {
            try {
                Thread.currentThread().setContextClassLoader(bootstrap.getClassLoader());
                try {
                    for (final CamelContext camelContext : bootstrap.createSpringCamelContexts()) {
                        try {
                            ProxyUtils.invokeProxied(new ProxiedAction(){

                                @Override
                                public void run() throws Exception {
                                    camelContext.start();
                                }
                            }, bootstrap.getClassLoader());
                        }
                        catch (Exception ex) {
                            throw new StartException("Cannot start camel context: " + camelContext.getName(), (Throwable)ex);
                        }
                    }
                }
                catch (Exception e) {
                    throw new StartException("Cannot create camel context: " + this.runtimeName, (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    public void stop(StopContext context) {
        Collections.reverse(this.bootstraps);
        for (SpringCamelContextBootstrap bootstrap : this.bootstraps) {
            List<SpringCamelContext> camelctxList = bootstrap.getSpringCamelContexts();
            for (CamelContext camelContext : camelctxList) {
                try {
                    camelContext.stop();
                }
                catch (Exception ex) {
                    CamelLogger.LOGGER.warn("Cannot stop camel context: " + camelContext.getName(), (Throwable)ex);
                }
            }
        }
    }
}

