/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.CamelContextTrackerRegistry;
import org.apache.camel.management.event.CamelContextStartingEvent;
import org.apache.camel.management.event.CamelContextStoppedEvent;
import org.apache.camel.spi.CamelContextTracker;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.EventNotifierSupport;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelContextRegistry;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.CamelSubsytemExtension;
import org.wildfly.extension.camel.ContextCreateHandler;
import org.wildfly.extension.camel.ContextCreateHandlerRegistry;
import org.wildfly.extension.camel.SpringCamelContextFactory;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettingsProcessor;
import org.wildfly.extension.camel.handler.ModuleClassLoaderAssociationHandler;
import org.wildfly.extension.camel.parser.SubsystemState;
import org.wildfly.extension.camel.service.SecurityActions;
import org.wildfly.extension.gravia.GraviaConstants;

public class CamelContextRegistryService
extends AbstractService<MutableCamelContextRegistry> {
    private static final String SPRING_BEANS_HEADER = "<beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd'>";
    private final SubsystemState subsystemState;
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private final InjectedValue<ContextCreateHandlerRegistry> injectedHandlerRegistry = new InjectedValue();
    private MutableCamelContextRegistry contextRegistry;
    private ServiceRegistration<CamelContextRegistry> registration;

    public static ServiceController<MutableCamelContextRegistry> addService(ServiceTarget serviceTarget, SubsystemState subsystemState) {
        CamelContextRegistryService service = new CamelContextRegistryService(subsystemState);
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CAMEL_CONTEXT_REGISTRY_SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, service.injectedRuntime);
        builder.addDependency(CamelConstants.CONTEXT_CREATE_HANDLER_REGISTRY_SERVICE_NAME, ContextCreateHandlerRegistry.class, service.injectedHandlerRegistry);
        return builder.install();
    }

    private CamelContextRegistryService(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    public void start(StartContext startContext) throws StartException {
        ContextCreateHandlerRegistry handlerRegistry = (ContextCreateHandlerRegistry)this.injectedHandlerRegistry.getValue();
        ServiceContainer serviceRegistry = startContext.getController().getServiceContainer();
        this.contextRegistry = new CamelContextRegistryImpl(handlerRegistry, (ServiceRegistry)serviceRegistry, startContext.getChildTarget());
        Runtime runtime = (Runtime)this.injectedRuntime.getValue();
        ModuleContext syscontext = runtime.getModuleContext();
        this.registration = syscontext.registerService(CamelContextRegistry.class, (Object)this.contextRegistry, null);
        for (String name : this.subsystemState.getContextDefinitionNames()) {
            this.createCamelContext(name, this.subsystemState.getContextDefinition(name));
        }
    }

    public void stop(StopContext context) {
        for (String name : this.subsystemState.getContextDefinitionNames()) {
            CamelContext camelctx = this.contextRegistry.getCamelContext(name);
            try {
                if (camelctx == null) continue;
                camelctx.stop();
            }
            catch (Exception e) {
                CamelLogger.LOGGER.warn("Cannot stop camel context: " + name, (Throwable)e);
            }
        }
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public MutableCamelContextRegistry getValue() {
        return this.contextRegistry;
    }

    public void createCamelContext(String name, String contextDefinition) {
        ClassLoader classLoader = CamelContextRegistry.class.getClassLoader();
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(classLoader);
            String beansXML = this.getBeansXML(name, contextDefinition);
            for (CamelContext camelContext : SpringCamelContextFactory.createCamelContextList(beansXML.getBytes(), classLoader)) {
                camelContext.start();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot create camel context: " + name, ex);
        }
        finally {
            SecurityActions.setContextClassLoader(tccl);
        }
    }

    private String getBeansXML(String name, String contextDefinition) {
        String hashReplaced = contextDefinition.replace("#{", "${");
        return "<beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd'><camelContext id='" + name + "' xmlns='http://camel.apache.org/schema/spring'>" + hashReplaced + "</camelContext></beans>";
    }

    final class CamelContextRegistryImpl
    extends CamelContextTracker
    implements MutableCamelContextRegistry {
        private final Set<CamelContext> contexts = new HashSet<CamelContext>();
        private final ContextCreateHandlerRegistry handlerRegistry;
        private final ServiceTarget serviceTarget;

        CamelContextRegistryImpl(ContextCreateHandlerRegistry handlerRegistry, ServiceRegistry serviceRegistry, ServiceTarget serviceTarget) {
            this.handlerRegistry = handlerRegistry;
            this.serviceTarget = serviceTarget;
            CamelContextTrackerRegistry.INSTANCE.addTracker((CamelContextTracker)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CamelContext getCamelContext(String name) {
            CamelContext result = null;
            Set<CamelContext> set = this.contexts;
            synchronized (set) {
                for (CamelContext camelctx : this.contexts) {
                    if (!camelctx.getName().equals(name)) continue;
                    result = camelctx;
                    break;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<CamelContext> getCamelContexts() {
            Set<CamelContext> set = this.contexts;
            synchronized (set) {
                return Collections.unmodifiableSet(this.contexts);
            }
        }

        public void contextCreated(CamelContext camelctx) {
            boolean enableIntegration = true;
            ModuleClassLoader moduleClassLoader = ModuleClassLoaderAssociationHandler.getModuleClassLoader(camelctx);
            ModuleIdentifier moduleId = moduleClassLoader.getModule().getIdentifier();
            if (moduleId.getName().startsWith("deployment.")) {
                String depName = moduleId.getName().substring(11);
                CamelDeploymentSettings camelDeploymentSettings = CamelDeploymentSettingsProcessor.getDeploymentSettings(depName);
                enableIntegration = camelDeploymentSettings.isEnabled();
            }
            if (enableIntegration) {
                for (ContextCreateHandler contextCreateHandler : this.handlerRegistry.getContextCreateHandlers(null)) {
                    contextCreateHandler.setup(camelctx);
                }
                ClassLoader classLoader = camelctx.getApplicationContextClassLoader();
                IllegalStateAssertion.assertTrue((Boolean)(classLoader instanceof ModuleClassLoader), (String)("Invalid class loader association: " + classLoader));
                for (ContextCreateHandler handler : this.handlerRegistry.getContextCreateHandlers(classLoader)) {
                    handler.setup(camelctx);
                }
                ManagementStrategy managementStrategy = camelctx.getManagementStrategy();
                managementStrategy.addEventNotifier((EventNotifier)new EventNotifierSupport(){

                    public void notify(EventObject event) throws Exception {
                        if (event instanceof CamelContextStartingEvent) {
                            CamelContextStartingEvent camelevt = (CamelContextStartingEvent)event;
                            CamelContext camelctx = camelevt.getContext();
                            CamelContextRegistryImpl.this.addCamelContext(camelctx);
                            CamelLogger.LOGGER.info("Camel context starting: {}", (Object)camelctx.getName());
                        } else if (event instanceof CamelContextStoppedEvent) {
                            CamelContextStoppedEvent camelevt = (CamelContextStoppedEvent)event;
                            CamelContext camelctx = camelevt.getContext();
                            CamelContextRegistryImpl.this.removeCamelContext(camelctx);
                            CamelLogger.LOGGER.info("Camel context stopped: {}", (Object)camelctx.getName());
                        }
                    }

                    public boolean isEnabled(EventObject event) {
                        return true;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCamelContext(final CamelContext camelctx) {
            Set<CamelContext> set = this.contexts;
            synchronized (set) {
                this.contexts.add(camelctx);
                CamelContextRegistryService.this.subsystemState.processExtensions(new Consumer<CamelSubsytemExtension>(){

                    @Override
                    public void accept(CamelSubsytemExtension plugin) {
                        plugin.addCamelContext(CamelContextRegistryImpl.this.serviceTarget, camelctx);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCamelContext(final CamelContext camelctx) {
            Set<CamelContext> set = this.contexts;
            synchronized (set) {
                CamelContextRegistryService.this.subsystemState.processExtensions(new Consumer<CamelSubsytemExtension>(){

                    @Override
                    public void accept(CamelSubsytemExtension plugin) {
                        plugin.removeCamelContext(camelctx);
                    }
                });
                this.contexts.remove(camelctx);
            }
        }
    }

    public static interface MutableCamelContextRegistry
    extends CamelContextRegistry {
        public void addCamelContext(CamelContext var1);

        public void removeCamelContext(CamelContext var1);
    }
}

