/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.extension.camel.ContextCreateHandler;

public final class CamelDeploymentSettings {
    public static final AttachmentKey<CamelDeploymentSettings> ATTACHMENT_KEY = AttachmentKey.create(CamelDeploymentSettings.class);
    private final List<CamelDeploymentSettings> children = new ArrayList<CamelDeploymentSettings>();
    private final List<ModuleIdentifier> dependencies = new ArrayList<ModuleIdentifier>();
    private final List<URL> camelContextUrls = new ArrayList<URL>();
    private ContextCreateHandler classResolverAssociationHandler;
    private boolean disabledByJbossAll;
    private boolean deploymentValid;
    private boolean camelAnnotationPresent;

    public boolean isEnabled() {
        if (this.disabledByJbossAll) {
            return false;
        }
        if (this.deploymentValid) {
            if (!this.camelContextUrls.isEmpty()) {
                return true;
            }
            for (CamelDeploymentSettings childDepSettings : this.children) {
                if (!childDepSettings.isEnabled()) continue;
                return true;
            }
            if (this.camelAnnotationPresent) {
                return true;
            }
            if (!this.dependencies.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public List<ModuleIdentifier> getModuleDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public void addModuleDependency(String moduleSpec) {
        this.dependencies.add(ModuleIdentifier.create((String)moduleSpec));
        this.disabledByJbossAll = false;
    }

    public List<URL> getCamelContextUrls() {
        return Collections.unmodifiableList(this.camelContextUrls);
    }

    public void addCamelContextUrl(URL url) {
        this.camelContextUrls.add(url);
    }

    public boolean isDeploymentValid() {
        return this.deploymentValid;
    }

    public void setDeploymentValid(boolean deploymentValid) {
        this.deploymentValid = deploymentValid;
    }

    public List<CamelDeploymentSettings> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(CamelDeploymentSettings child) {
        this.children.add(child);
    }

    public boolean isDisabledByJbossAll() {
        return this.disabledByJbossAll;
    }

    public void setDisabledByJbossAll(boolean disabledByJbossAll) {
        this.disabledByJbossAll = disabledByJbossAll;
    }

    public boolean isCamelAnnotationPresent() {
        return this.camelAnnotationPresent;
    }

    public void setCamelAnnotationPresent(boolean camelAnnotationPresent) {
        this.camelAnnotationPresent = camelAnnotationPresent;
    }

    public ContextCreateHandler getClassResolverAssociationHandler() {
        return this.classResolverAssociationHandler;
    }

    public void setClassResolverAssociationHandler(ContextCreateHandler classResolverAssociationHandler) {
        this.classResolverAssociationHandler = classResolverAssociationHandler;
    }
}

