/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.core.ManagedServlet;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.service.CamelEndpointDeploymentSchedulerService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowService;

public class CamelEndpointDeployerService
implements Service<CamelEndpointDeployerService> {
    private static final String MATCH_ALL_ENDPOINT_URI_PREFIX = "///*";
    private static final String MATCH_ALL_PREFIX = "/*";
    private static final String SERVICE_NAME = "EndpointDeployer";
    private final InjectedValue<DeploymentInfo> deploymentInfoSupplier = new InjectedValue();
    private final Map<URI, Deployment> deployments = new HashMap<URI, Deployment>();
    private final InjectedValue<CamelEndpointDeploymentSchedulerService> deploymentSchedulerServiceSupplier = new InjectedValue();
    private final InjectedValue<Host> hostSupplier = new InjectedValue();
    private final InjectedValue<ServletContainerService> servletContainerServiceSupplier = new InjectedValue();

    static DeploymentInfo adaptDeploymentInfo(DeploymentInfo src, URI uri, ServletInfo servletInfo) {
        String contextPath = uri.getPath();
        String deploymentName = src.getDeploymentName() + ":" + uri.getPath();
        DeploymentInfo info = new DeploymentInfo().setClassLoader(src.getClassLoader()).setContextPath(contextPath).setResourceManager(src.getResourceManager()).setMajorVersion(src.getMajorVersion()).setMinorVersion(src.getMinorVersion()).setDeploymentName(deploymentName).setClassIntrospecter(src.getClassIntrospecter());
        info.addServlet(servletInfo);
        for (Map.Entry e : src.getFilters().entrySet()) {
            info.addFilter(((FilterInfo)e.getValue()).clone());
        }
        info.setDisplayName(src.getDisplayName());
        block5: for (FilterMappingInfo fmi : src.getFilterMappings()) {
            switch (fmi.getMappingType()) {
                case URL: {
                    info.addFilterUrlMapping(fmi.getFilterName(), fmi.getMapping(), fmi.getDispatcher());
                    continue block5;
                }
                case SERVLET: {
                    info.addFilterServletNameMapping(fmi.getFilterName(), fmi.getMapping(), fmi.getDispatcher());
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected " + FilterMappingInfo.MappingType.class.getName() + " " + fmi.getMappingType());
        }
        info.addListeners((Collection)src.getListeners());
        info.addServletContainerInitalizers(src.getServletContainerInitializers());
        for (ThreadSetupHandler a : src.getThreadSetupActions()) {
            info.addThreadSetupAction(a);
        }
        for (Map.Entry en : src.getInitParameters().entrySet()) {
            info.addInitParameter((String)en.getKey(), (String)en.getValue());
        }
        for (Map.Entry en : src.getServletContextAttributes().entrySet()) {
            info.addServletContextAttribute((String)en.getKey(), en.getValue());
        }
        info.addWelcomePages((Collection)src.getWelcomePages());
        info.addErrorPages((Collection)src.getErrorPages());
        info.addMimeMappings((Collection)src.getMimeMappings());
        info.setExecutor(src.getExecutor());
        info.setAsyncExecutor(src.getAsyncExecutor());
        info.setTempDir(src.getTempDir());
        info.setJspConfigDescriptor(src.getJspConfigDescriptor());
        info.setDefaultServletConfig(src.getDefaultServletConfig());
        for (Map.Entry en : src.getLocaleCharsetMapping().entrySet()) {
            info.addLocaleCharsetMapping((String)en.getKey(), (String)en.getValue());
        }
        info.setSessionManagerFactory(src.getSessionManagerFactory());
        LoginConfig loginConfig = src.getLoginConfig();
        if (loginConfig != null) {
            info.setLoginConfig(loginConfig.clone());
        }
        info.setIdentityManager(src.getIdentityManager());
        info.setConfidentialPortManager(src.getConfidentialPortManager());
        info.setDefaultEncoding(src.getDefaultEncoding());
        info.setUrlEncoding(src.getUrlEncoding());
        info.addSecurityConstraints(CamelEndpointDeployerService.filterConstraints(src, uri));
        for (HandlerWrapper handlerWrapper : src.getOuterHandlerChainWrappers()) {
            info.addOuterHandlerChainWrapper(handlerWrapper);
        }
        for (HandlerWrapper handlerWrapper : src.getInnerHandlerChainWrappers()) {
            info.addInnerHandlerChainWrapper(handlerWrapper);
        }
        info.setInitialSecurityWrapper(src.getInitialSecurityWrapper());
        for (HandlerWrapper handlerWrapper : src.getSecurityWrappers()) {
            info.addSecurityWrapper(handlerWrapper);
        }
        for (HandlerWrapper handlerWrapper : src.getInitialHandlerChainWrappers()) {
            info.addInitialHandlerChainWrapper(handlerWrapper);
        }
        info.addSecurityRoles((Collection)src.getSecurityRoles());
        info.addNotificationReceivers((Collection)src.getNotificationReceivers());
        info.setAllowNonStandardWrappers(src.isAllowNonStandardWrappers());
        info.setDefaultSessionTimeout(src.getDefaultSessionTimeout());
        info.setServletContextAttributeBackingMap(src.getServletContextAttributeBackingMap());
        info.setServletSessionConfig(src.getServletSessionConfig());
        info.setHostName(src.getHostName());
        info.setDenyUncoveredHttpMethods(src.isDenyUncoveredHttpMethods());
        info.setServletStackTraces(src.getServletStackTraces());
        info.setInvalidateSessionOnLogout(src.isInvalidateSessionOnLogout());
        info.setDefaultCookieVersion(src.getDefaultCookieVersion());
        info.setSessionPersistenceManager(src.getSessionPersistenceManager());
        for (Map.Entry entry : src.getPrincipalVersusRolesMap().entrySet()) {
            info.addPrincipalVsRoleMappings((String)entry.getKey(), (Collection)entry.getValue());
        }
        info.setIgnoreFlush(src.isIgnoreFlush());
        info.setAuthorizationManager(src.getAuthorizationManager());
        for (Map.Entry entry : src.getAuthenticationMechanisms().entrySet()) {
            info.addAuthenticationMechanism((String)entry.getKey(), (AuthenticationMechanismFactory)entry.getValue());
        }
        info.setJaspiAuthenticationMechanism(src.getJaspiAuthenticationMechanism());
        info.setSecurityContextFactory(src.getSecurityContextFactory());
        info.setServerName(src.getServerName());
        info.setMetricsCollector(src.getMetricsCollector());
        info.setSessionConfigWrapper(src.getSessionConfigWrapper());
        info.setEagerFilterInit(src.isEagerFilterInit());
        info.setDisableCachingForSecuredPages(src.isDisableCachingForSecuredPages());
        info.setExceptionHandler(src.getExceptionHandler());
        info.setEscapeErrorMessage(src.isEscapeErrorMessage());
        for (SessionListener sessionListener : src.getSessionListeners()) {
            info.addSessionListener(sessionListener);
        }
        for (LifecycleInterceptor lifecycleInterceptor : src.getLifecycleInterceptors()) {
            info.addLifecycleInterceptor(lifecycleInterceptor);
        }
        info.setAuthenticationMode(src.getAuthenticationMode());
        info.setDefaultMultipartConfig(src.getDefaultMultipartConfig());
        info.setContentTypeCacheSize(src.getContentTypeCacheSize());
        info.setSessionIdGenerator(src.getSessionIdGenerator());
        info.setSendCustomReasonPhraseOnError(src.isSendCustomReasonPhraseOnError());
        info.setChangeSessionIdOnLogin(src.isChangeSessionIdOnLogin());
        info.setCrawlerSessionManagerConfig(src.getCrawlerSessionManagerConfig());
        info.setSecurityDisabled(src.isSecurityDisabled());
        info.setUseCachedAuthenticationMechanism(src.isUseCachedAuthenticationMechanism());
        info.setCheckOtherSessionManagers(src.isCheckOtherSessionManagers());
        return info;
    }

    public static ServiceController<CamelEndpointDeployerService> addService(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, ServiceName deploymentInfoServiceName, ServiceName hostServiceName) {
        CamelEndpointDeployerService service = new CamelEndpointDeployerService();
        ServiceBuilder sb = serviceTarget.addService(CamelEndpointDeployerService.deployerServiceName(deploymentUnit.getServiceName()), (Service)service);
        sb.addDependency(hostServiceName, Host.class, service.hostSupplier);
        sb.addDependency(deploymentInfoServiceName, DeploymentInfo.class, service.deploymentInfoSupplier);
        sb.addDependency(CamelEndpointDeploymentSchedulerService.deploymentSchedulerServiceName(deploymentUnit.getServiceName()), CamelEndpointDeploymentSchedulerService.class, service.deploymentSchedulerServiceSupplier);
        sb.addDependency(UndertowService.SERVLET_CONTAINER.append(new String[]{"default"}), ServletContainerService.class, service.servletContainerServiceSupplier);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration != null) {
            for (ComponentConfiguration c : moduleConfiguration.getComponentConfigurations()) {
                sb.addDependency(c.getComponentDescription().getStartServiceName());
            }
        }
        return sb.install();
    }

    public static ServiceName deployerServiceName(ServiceName deploymentUnitServiceName) {
        return deploymentUnitServiceName.append(new String[]{SERVICE_NAME});
    }

    static List<SecurityConstraint> filterConstraints(DeploymentInfo mainDeploymentInfo, URI uri) {
        ArrayList<SecurityConstraint> result = new ArrayList<SecurityConstraint>();
        String uriPath = uri.getPath();
        String endpointUriPrefix = "//" + uriPath;
        String mainContextPath = mainDeploymentInfo.getContextPath();
        boolean isRelativeUri = uriPath.startsWith(mainContextPath);
        String relativeUriPath = isRelativeUri ? uriPath.substring(mainContextPath.length()) : null;
        for (SecurityConstraint mainSecurityConstraint : mainDeploymentInfo.getSecurityConstraints()) {
            SecurityConstraint endpointSecurityConstraint = new SecurityConstraint();
            for (WebResourceCollection mainResourceCollection : mainSecurityConstraint.getWebResourceCollections()) {
                WebResourceCollection endpointResourceCollection = new WebResourceCollection();
                for (String mainUrlPattern : mainResourceCollection.getUrlPatterns()) {
                    if (MATCH_ALL_ENDPOINT_URI_PREFIX.equals(mainUrlPattern)) {
                        endpointResourceCollection.addUrlPattern(MATCH_ALL_PREFIX);
                        continue;
                    }
                    UrlPattern pattern = new UrlPattern(mainUrlPattern);
                    String relativePattern = null;
                    if (isRelativeUri) {
                        relativePattern = pattern.relativize(relativeUriPath);
                        if (relativePattern == null) continue;
                        endpointResourceCollection.addUrlPattern(relativePattern);
                        continue;
                    }
                    relativePattern = pattern.relativize(endpointUriPrefix);
                    if (relativePattern == null) continue;
                    endpointResourceCollection.addUrlPattern(relativePattern);
                }
                if (endpointResourceCollection.getUrlPatterns().isEmpty()) continue;
                endpointResourceCollection.addHttpMethods((Collection)mainResourceCollection.getHttpMethods());
                endpointResourceCollection.addHttpMethodOmissions((Collection)mainResourceCollection.getHttpMethodOmissions());
                endpointSecurityConstraint.addWebResourceCollection(endpointResourceCollection);
            }
            if (endpointSecurityConstraint.getWebResourceCollections().isEmpty()) continue;
            endpointSecurityConstraint.addRolesAllowed((Collection)mainSecurityConstraint.getRolesAllowed());
            endpointSecurityConstraint.setEmptyRoleSemantic(mainSecurityConstraint.getEmptyRoleSemantic());
            endpointSecurityConstraint.setTransportGuaranteeType(CamelEndpointDeployerService.transportGuaranteeType(uri, mainSecurityConstraint.getTransportGuaranteeType()));
            result.add(endpointSecurityConstraint);
        }
        if (result.isEmpty() && uri.getScheme().equals("https")) {
            WebResourceCollection webResourceCollection = new WebResourceCollection();
            webResourceCollection.addUrlPattern(MATCH_ALL_PREFIX);
            SecurityConstraint endpointSecurityConstraint = new SecurityConstraint();
            endpointSecurityConstraint.addWebResourceCollection(webResourceCollection);
            endpointSecurityConstraint.setTransportGuaranteeType(TransportGuaranteeType.CONFIDENTIAL);
            endpointSecurityConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
            result.add(endpointSecurityConstraint);
        }
        return result;
    }

    static TransportGuaranteeType transportGuaranteeType(URI uri, TransportGuaranteeType transportGuaranteeType) {
        if (uri.getScheme().equals("https")) {
            return TransportGuaranteeType.CONFIDENTIAL;
        }
        if (transportGuaranteeType != null) {
            return transportGuaranteeType;
        }
        return TransportGuaranteeType.NONE;
    }

    public CamelEndpointDeployerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(URI uri, CamelEndpointDeploymentSchedulerService.EndpointHttpHandler endpointHttpHandler) {
        ServletInfo servletInfo = Servlets.servlet((String)"EndpointServlet", EndpointServlet.class).addMapping(MATCH_ALL_PREFIX).setAsyncSupported(true);
        DeploymentInfo mainDeploymentInfo = (DeploymentInfo)this.deploymentInfoSupplier.getValue();
        DeploymentInfo endPointDeplyomentInfo = CamelEndpointDeployerService.adaptDeploymentInfo(mainDeploymentInfo, uri, servletInfo);
        CamelLogger.LOGGER.debug("Deploying endpoint {}", (Object)endPointDeplyomentInfo.getDeploymentName());
        DeploymentManager manager = ((ServletContainerService)this.servletContainerServiceSupplier.getValue()).getServletContainer().addDeployment(endPointDeplyomentInfo);
        manager.deploy();
        Deployment deployment = manager.getDeployment();
        try {
            HttpHandler servletHandler = manager.start();
            ((Host)this.hostSupplier.getValue()).registerDeployment(deployment, servletHandler);
            ManagedServlet managedServlet = deployment.getServlets().getManagedServlet("EndpointServlet");
            EndpointServlet servletInstance = (EndpointServlet)((Object)managedServlet.getServlet().getInstance());
            servletInstance.setEndpointHttpHandler(endpointHttpHandler);
        }
        catch (ServletException ex) {
            throw new IllegalStateException(ex);
        }
        Map<URI, Deployment> map = this.deployments;
        synchronized (map) {
            this.deployments.put(uri, deployment);
        }
    }

    public void start(StartContext context) throws StartException {
        ((CamelEndpointDeploymentSchedulerService)this.deploymentSchedulerServiceSupplier.getValue()).registerDeployer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        Map<URI, Deployment> map = this.deployments;
        synchronized (map) {
            for (Deployment deployment : this.deployments.values()) {
                CamelLogger.LOGGER.debug("Undeploying endpoint {}", (Object)deployment.getDeploymentInfo().getDeploymentName());
                ((Host)this.hostSupplier.getValue()).unregisterDeployment(deployment);
            }
            this.deployments.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(URI uri) {
        Map<URI, Deployment> map = this.deployments;
        synchronized (map) {
            Deployment removedDeployment = this.deployments.remove(uri);
            if (removedDeployment != null) {
                CamelLogger.LOGGER.debug("Undeploying endpoint {}", (Object)removedDeployment.getDeploymentInfo().getDeploymentName());
                try {
                    ((Host)this.hostSupplier.getValue()).unregisterDeployment(removedDeployment);
                }
                catch (IllegalStateException e) {
                    CamelLogger.LOGGER.warn("Could not undeploy endpoint " + removedDeployment.getDeploymentInfo().getDeploymentName(), (Throwable)e);
                }
            }
        }
    }

    static class UrlPattern {
        private final String source;

        public UrlPattern(String source) {
            this.source = source;
        }

        public String relativize(String path) {
            StringTokenizer patternTokenizer = new StringTokenizer(this.source, "/", true);
            StringTokenizer pathTokenizer = new StringTokenizer(path, "/", true);
            while (pathTokenizer.hasMoreTokens()) {
                if (!patternTokenizer.hasMoreTokens()) {
                    return null;
                }
                String patternToken = patternTokenizer.nextToken();
                String pathToken = pathTokenizer.nextToken();
                boolean isSlash = patternToken.equals("/");
                if (isSlash != pathToken.equals("/")) {
                    return null;
                }
                if (isSlash || "*".equals(pathToken)) continue;
                StringTokenizer segmentTokenizer = new StringTokenizer(patternToken, "*", true);
                StringBuilder segmentPatternBuilder = new StringBuilder(patternToken.length());
                while (segmentTokenizer.hasMoreTokens()) {
                    String segmentToken = segmentTokenizer.nextToken();
                    if ("*".equals(segmentToken)) {
                        segmentPatternBuilder.append(".*");
                        continue;
                    }
                    segmentPatternBuilder.append(Pattern.quote(segmentToken));
                }
                Pattern pat = Pattern.compile(segmentPatternBuilder.toString());
                if (pat.matcher(pathToken).matches()) continue;
                return null;
            }
            StringBuilder result = new StringBuilder();
            while (patternTokenizer.hasMoreTokens()) {
                result.append(patternTokenizer.nextToken());
            }
            if (result.length() == 0) {
                return "";
            }
            if (result.charAt(0) != '/') {
                return "/" + result.toString();
            }
            return result.toString();
        }
    }

    static class EndpointServlet
    extends HttpServlet {
        public static final String NAME = "EndpointServlet";
        private CamelEndpointDeploymentSchedulerService.EndpointHttpHandler endpointHttpHandler;

        EndpointServlet() {
        }

        protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            this.endpointHttpHandler.service(this.getServletContext(), req, res);
        }

        public void setEndpointHttpHandler(CamelEndpointDeploymentSchedulerService.EndpointHttpHandler endpointHttpHandler) {
            this.endpointHttpHandler = endpointHttpHandler;
        }
    }
}

