/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.deployment;

import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.deployment.CamelDeploymentSettings;
import org.wildfly.extension.camel.service.CamelEndpointDeploymentSchedulerService;

public class CamelEndpointDeploymentSchedulerProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CamelDeploymentSettings depSettings = (CamelDeploymentSettings)deploymentUnit.getAttachment(CamelDeploymentSettings.ATTACHMENT_KEY);
        if (!depSettings.isEnabled()) {
            return;
        }
        List subDeployments = deploymentUnit.getAttachmentList(Attachments.SUB_DEPLOYMENTS);
        if (subDeployments != null && !subDeployments.isEmpty()) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceController<CamelEndpointDeploymentSchedulerService> serviceController = CamelEndpointDeploymentSchedulerService.addService(deploymentUnit.getServiceName(), deploymentUnit.getName(), serviceTarget);
        phaseContext.addDeploymentDependency(serviceController.getName(), CamelConstants.CAMEL_ENDPOINT_DEPLOYMENT_SCHEDULER_REGISTRY_KEY);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

