/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.undertow;

import java.net.URI;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfConsumer;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfSpringEndpoint;
import org.wildfly.extension.camel.CamelLogger;

public class WildFlyCxfComponent
extends CxfComponent {
    protected CxfEndpoint createCxfEndpoint(String remaining) {
        return new WildflyCxfEndpoint(remaining, this);
    }

    protected CxfEndpoint createCxfSpringEndpoint(String beanId) throws Exception {
        return super.createCxfSpringEndpoint(beanId);
    }

    class WildflyCxfConsumer
    extends CxfConsumer {
        WildflyCxfConsumer(CxfEndpoint endpoint, Processor processor) throws Exception {
            super(endpoint, processor);
            URI uri = new URI(endpoint.getEndpointUri());
            String host = uri.getHost();
            int port = uri.getPort();
            if (!"localhost".equals(host) || port > 0) {
                CamelLogger.LOGGER.warn("Ignoring configured host/port: {}", (Object)uri);
            }
        }
    }

    class WildflyCxfSpringEndpoint
    extends CxfSpringEndpoint {
        WildflyCxfSpringEndpoint() {
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return new WildflyCxfConsumer((CxfEndpoint)this, processor);
        }
    }

    class WildflyCxfEndpoint
    extends CxfEndpoint {
        WildflyCxfEndpoint(String remaining, WildFlyCxfComponent component) {
            super(remaining, (CxfComponent)component);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return new WildflyCxfConsumer(this, processor);
        }
    }
}

