/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.undertow;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathTemplateHandler;
import io.undertow.servlet.api.Deployment;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.camel.component.undertow.UndertowHost;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.parser.SubsystemRuntimeState;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.undertow.AbstractUndertowEventListener;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowService;

public class CamelUndertowHostService
extends AbstractService<UndertowHost> {
    private static final ServiceName SERVICE_NAME = CamelConstants.CAMEL_BASE_NAME.append(new String[]{"Undertow"});
    private final InjectedValue<SocketBinding> injectedHttpSocketBinding = new InjectedValue();
    private final InjectedValue<UndertowService> injectedUndertowService = new InjectedValue();
    private final InjectedValue<Host> injectedDefaultHost = new InjectedValue();
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private final SubsystemRuntimeState runtimeState;
    private ServiceRegistration<UndertowHost> registration;
    private UndertowEventListener eventListener;
    private UndertowHost undertowHost;

    public static ServiceController<UndertowHost> addService(ServiceTarget serviceTarget, SubsystemRuntimeState runtimeState) {
        CamelUndertowHostService service = new CamelUndertowHostService(runtimeState);
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, service.injectedRuntime);
        builder.addDependency(UndertowService.UNDERTOW, UndertowService.class, service.injectedUndertowService);
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"http"}), SocketBinding.class, service.injectedHttpSocketBinding);
        builder.addDependency(UndertowService.virtualHostName((String)"default-server", (String)"default-host"), Host.class, service.injectedDefaultHost);
        return builder.install();
    }

    private CamelUndertowHostService(SubsystemRuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    public void start(StartContext startContext) throws StartException {
        this.runtimeState.setHttpHost(this.getConnectionURL());
        this.eventListener = new CamelUndertowEventListener();
        ((UndertowService)this.injectedUndertowService.getValue()).registerListener(this.eventListener);
        this.undertowHost = new WildFlyUndertowHost((Host)this.injectedDefaultHost.getValue());
        ModuleContext syscontext = ((Runtime)this.injectedRuntime.getValue()).getModuleContext();
        this.registration = syscontext.registerService(UndertowHost.class, (Object)this.undertowHost, null);
    }

    private URL getConnectionURL() throws StartException {
        URL result;
        SocketBinding socketBinding = (SocketBinding)this.injectedHttpSocketBinding.getValue();
        InetAddress address = socketBinding.getNetworkInterfaceBinding().getAddress();
        try {
            String hostAddress = NetworkUtils.formatPossibleIpv6Address((String)address.getHostAddress());
            result = new URL(socketBinding.getName() + "://" + hostAddress + ":" + socketBinding.getPort());
        }
        catch (MalformedURLException ex) {
            throw new StartException((Throwable)ex);
        }
        return result;
    }

    public void stop(StopContext context) {
        ((UndertowService)this.injectedUndertowService.getValue()).unregisterListener(this.eventListener);
        this.registration.unregister();
    }

    public UndertowHost getValue() throws IllegalStateException {
        return this.undertowHost;
    }

    class CamelUndertowEventListener
    extends AbstractUndertowEventListener {
        CamelUndertowEventListener() {
        }

        public void onDeploymentStart(Deployment dep, Host host) {
            CamelUndertowHostService.this.runtimeState.addHttpContext(dep.getServletContext().getContextPath());
        }

        public void onDeploymentStop(Deployment dep, Host host) {
            CamelUndertowHostService.this.runtimeState.removeHttpContext(dep.getServletContext().getContextPath());
        }
    }

    class WildFlyUndertowHost
    implements UndertowHost {
        private static final String REST_PATH_PLACEHOLDER = "{";
        private final Host defaultHost;

        WildFlyUndertowHost(Host host) {
            this.defaultHost = host;
        }

        public void validateEndpointURI(URI httpURI) {
            boolean portMatched;
            boolean bl = portMatched = httpURI.getPort() == 0 || httpURI.getPort() == -1;
            if (!portMatched) {
                for (ListenerService service : this.defaultHost.getServer().getListeners()) {
                    InjectedValue binding = service.getBinding();
                    if (binding == null || ((SocketBinding)binding.getValue()).getPort() != httpURI.getPort()) continue;
                    portMatched = true;
                    break;
                }
            }
            IllegalStateAssertion.assertEquals((Object)"localhost", (Object)httpURI.getHost(), (String)("Cannot bind to host other than 'localhost': " + httpURI));
            IllegalStateAssertion.assertTrue((Boolean)portMatched, (String)("Cannot bind to specific port: " + httpURI));
        }

        public void registerHandler(String path, HttpHandler handler) {
            if (path.contains(REST_PATH_PLACEHOLDER)) {
                String pathPrefix = path.substring(0, path.indexOf(REST_PATH_PLACEHOLDER));
                String remaining = path.substring(path.indexOf(REST_PATH_PLACEHOLDER));
                PathTemplateHandler pathTemplateHandler = Handlers.pathTemplate();
                pathTemplateHandler.add(remaining, handler);
                this.defaultHost.registerHandler(pathPrefix, (HttpHandler)pathTemplateHandler);
            } else {
                this.defaultHost.registerHandler(path, (HttpHandler)Handlers.path((HttpHandler)handler));
                this.defaultHost.registerHandler(path, handler);
            }
        }

        public void unregisterHandler(String path) {
            if (path.contains(REST_PATH_PLACEHOLDER)) {
                this.defaultHost.unregisterHandler(path.substring(0, path.indexOf(REST_PATH_PLACEHOLDER)));
            } else {
                this.defaultHost.unregisterHandler(path);
            }
        }
    }
}

