/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.undertow;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.util.Methods;
import io.undertow.util.PathTemplate;
import io.undertow.util.URLUtils;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowHost;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.parser.SubsystemState;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;

public class CamelUndertowHostService
extends AbstractService<UndertowHost> {
    private static final ServiceName SERVICE_NAME = CamelConstants.CAMEL_BASE_NAME.append(new String[]{"Undertow"});
    private final InjectedValue<SocketBinding> injectedHttpSocketBinding = new InjectedValue();
    private final InjectedValue<UndertowService> injectedUndertowService = new InjectedValue();
    private final InjectedValue<Host> injectedDefaultHost = new InjectedValue();
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private final SubsystemState.RuntimeState runtimeState;
    private ServiceRegistration<UndertowHost> registration;
    private UndertowEventListener eventListener;
    private UndertowHost undertowHost;

    public static ServiceController<UndertowHost> addService(ServiceTarget serviceTarget, SubsystemState.RuntimeState runtimeState) {
        CamelUndertowHostService service = new CamelUndertowHostService(runtimeState);
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, service.injectedRuntime);
        builder.addDependency(UndertowService.UNDERTOW, UndertowService.class, service.injectedUndertowService);
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"http"}), SocketBinding.class, service.injectedHttpSocketBinding);
        builder.addDependency(UndertowService.virtualHostName((String)"default-server", (String)"default-host"), Host.class, service.injectedDefaultHost);
        return builder.install();
    }

    private CamelUndertowHostService(SubsystemState.RuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    public void start(StartContext startContext) throws StartException {
        this.runtimeState.setHttpHost(this.getConnectionURL());
        this.eventListener = new CamelUndertowEventListener();
        ((UndertowService)this.injectedUndertowService.getValue()).registerListener(this.eventListener);
        this.undertowHost = new WildFlyUndertowHost((Host)this.injectedDefaultHost.getValue());
        ModuleContext syscontext = ((Runtime)this.injectedRuntime.getValue()).getModuleContext();
        this.registration = syscontext.registerService(UndertowHost.class, (Object)this.undertowHost, null);
    }

    private URL getConnectionURL() throws StartException {
        URL result;
        SocketBinding socketBinding = (SocketBinding)this.injectedHttpSocketBinding.getValue();
        InetAddress address = socketBinding.getNetworkInterfaceBinding().getAddress();
        try {
            String hostAddress = NetworkUtils.formatPossibleIpv6Address((String)address.getHostAddress());
            result = new URL(socketBinding.getName() + "://" + hostAddress + ":" + socketBinding.getPort());
        }
        catch (MalformedURLException ex) {
            throw new StartException((Throwable)ex);
        }
        return result;
    }

    public void stop(StopContext context) {
        ((UndertowService)this.injectedUndertowService.getValue()).unregisterListener(this.eventListener);
        this.registration.unregister();
    }

    public UndertowHost getValue() throws IllegalStateException {
        return this.undertowHost;
    }

    class CamelUndertowEventListener
    implements UndertowEventListener {
        CamelUndertowEventListener() {
        }

        public void onDeploymentStart(Deployment dep, Host host) {
            this.checkForOverlappingContextPath(dep);
            CamelUndertowHostService.this.runtimeState.addHttpContext(dep.getServletContext().getContextPath());
        }

        public void onDeploymentStop(Deployment dep, Host host) {
            CamelUndertowHostService.this.runtimeState.removeHttpContext(dep.getServletContext().getContextPath());
        }

        private void checkForOverlappingContextPath(Deployment dep) {
            DeploymentInfo depInfo = dep.getDeploymentInfo();
            if (dep.getHandler() != null) {
                String contextPath = depInfo.getContextPath();
                WildFlyUndertowHost wildFlyUndertowHost = (WildFlyUndertowHost)CamelUndertowHostService.this.undertowHost;
                boolean match = wildFlyUndertowHost.getRegisteredPaths().stream().anyMatch(path -> path.equals(contextPath));
                IllegalStateAssertion.assertFalse((Boolean)match, (String)("Cannot overwrite context path " + contextPath + " owned by camel-undertow" + contextPath));
            }
        }
    }

    static class MethodPathMapping {
        private String method;
        private String path;

        private MethodPathMapping(String method, String path) {
            this.method = method;
            this.path = path;
        }

        static MethodPathMapping of(String method, String path) {
            return new MethodPathMapping(method, path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodPathMapping that = (MethodPathMapping)o;
            if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
                return false;
            }
            return this.path != null ? this.path.equals(that.path) : that.path == null;
        }

        public int hashCode() {
            int result = this.method != null ? this.method.hashCode() : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }

        public String toString() {
            return String.format("%s: %s", this.method, this.path);
        }
    }

    class DelegatingRoutingHandler
    implements HttpHandler {
        private final List<MethodPathMapping> paths = new CopyOnWriteArrayList<MethodPathMapping>();
        private final RoutingHandler delegate = Handlers.routing();

        DelegatingRoutingHandler() {
        }

        DelegatingRoutingHandler add(String method, String path, HttpHandler handler) {
            MethodPathMapping mapping = MethodPathMapping.of(method, path);
            IllegalStateAssertion.assertFalse((Boolean)(this.paths.contains(mapping) && !method.equals("OPTIONS") ? 1 : 0), (String)("Cannot register duplicate handler for " + mapping));
            CamelLogger.LOGGER.debug("Registered paths {}", (Object)this.toString());
            this.delegate.add(method, path, handler);
            this.paths.add(mapping);
            return this;
        }

        void remove(String method, String path) {
            this.delegate.remove(Methods.fromString((String)method), path);
            this.paths.remove(MethodPathMapping.of(method, path));
        }

        boolean hasRegisteredPaths() {
            return !this.paths.isEmpty();
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRelativePath().isEmpty()) {
                exchange.setRelativePath("/");
            }
            this.delegate.handleRequest(exchange);
        }

        public String toString() {
            String formattedPaths = this.paths.stream().map(methodPathMapping -> methodPathMapping.toString()).collect(Collectors.joining(", "));
            return String.format("DelegatingRoutingHandler [%s]", formattedPaths);
        }
    }

    class WildFlyUndertowHost
    implements UndertowHost {
        private static final String REST_PATH_PLACEHOLDER = "{";
        private static final String DEFAULT_METHODS = "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
        private final Map<String, DelegatingRoutingHandler> handlers = new ConcurrentHashMap<String, DelegatingRoutingHandler>();
        private final Host defaultHost;

        WildFlyUndertowHost(Host host) {
            this.defaultHost = host;
        }

        public void validateEndpointURI(URI httpURI) {
            this.validateEndpointPort(httpURI);
            this.validateEndpointContextPath(httpURI);
        }

        private void validateEndpointPort(URI httpURI) {
            boolean portMatched;
            boolean bl = portMatched = httpURI.getPort() == 0 || httpURI.getPort() == -1;
            if (!portMatched) {
                for (UndertowListener listener : this.defaultHost.getServer().getListeners()) {
                    SocketBinding binding = listener.getSocketBinding();
                    if (binding == null || binding.getPort() != httpURI.getPort()) continue;
                    portMatched = true;
                    break;
                }
            }
            if (!"localhost".equals(httpURI.getHost())) {
                CamelLogger.LOGGER.debug("Cannot bind to host other than 'localhost': {}", (Object)httpURI);
            }
            if (!portMatched) {
                CamelLogger.LOGGER.debug("Cannot bind to specific port: {}", (Object)httpURI);
            }
        }

        private void validateEndpointContextPath(URI httpURI) {
            String undertowEndpointPath = this.getContextPath(httpURI);
            Set deployments = this.defaultHost.getDeployments();
            for (Deployment deployment : deployments) {
                DeploymentInfo depInfo = deployment.getDeploymentInfo();
                String contextPath = depInfo.getContextPath();
                boolean contextPathExists = deployment.getHandler() != null && contextPath.equals(undertowEndpointPath);
                IllegalStateAssertion.assertFalse((Boolean)contextPathExists, (String)("Cannot overwrite context path " + contextPath + " owned by " + depInfo.getDeploymentName()));
            }
        }

        public void registerHandler(HttpHandlerRegistrationInfo reginfo, HttpHandler handler) {
            boolean matchOnUriPrefix = reginfo.isMatchOnUriPrefix();
            URI httpURI = reginfo.getUri();
            String contextPath = this.getContextPath(httpURI);
            CamelLogger.LOGGER.debug("Using context path {}", (Object)contextPath);
            String relativePath = this.getRelativePath(httpURI, matchOnUriPrefix);
            CamelLogger.LOGGER.debug("Using relative path {}", (Object)relativePath);
            DelegatingRoutingHandler routingHandler = this.handlers.get(contextPath);
            if (routingHandler == null) {
                routingHandler = new DelegatingRoutingHandler();
                this.handlers.put(contextPath, routingHandler);
                CamelLogger.LOGGER.debug("Created new DelegatingRoutingHandler {}", (Object)routingHandler);
            }
            String methods = reginfo.getMethodRestrict() == null ? DEFAULT_METHODS : reginfo.getMethodRestrict();
            CamelLogger.LOGGER.debug("Using methods {}", (Object)methods);
            for (String method : methods.split(",")) {
                CamelLogger.LOGGER.debug("Adding {}: {} for handler {}", new Object[]{method, relativePath, handler});
                routingHandler.add(method, relativePath, handler);
            }
            CamelLogger.LOGGER.debug("Registering DelegatingRoutingHandler on path {}", (Object)contextPath);
            this.defaultHost.registerHandler(contextPath, (HttpHandler)routingHandler);
        }

        public void unregisterHandler(HttpHandlerRegistrationInfo reginfo) {
            boolean matchOnUriPrefix = reginfo.isMatchOnUriPrefix();
            URI httpURI = reginfo.getUri();
            String contextPath = this.getContextPath(httpURI);
            CamelLogger.LOGGER.debug("unregisterHandler {}", (Object)contextPath);
            DelegatingRoutingHandler routingHandler = this.handlers.get(contextPath);
            if (routingHandler != null) {
                String methods = reginfo.getMethodRestrict() == null ? DEFAULT_METHODS : reginfo.getMethodRestrict();
                for (String method : methods.split(",")) {
                    String relativePath = this.getRelativePath(httpURI, matchOnUriPrefix);
                    routingHandler.remove(method, relativePath);
                    CamelLogger.LOGGER.debug("Unregistered {}: {}", (Object)method, (Object)relativePath);
                }
                if (!routingHandler.hasRegisteredPaths()) {
                    this.defaultHost.unregisterHandler(contextPath);
                    this.handlers.remove(contextPath);
                    CamelLogger.LOGGER.debug("Unregistered root handler from {}", (Object)contextPath);
                }
            }
        }

        private Set<String> getRegisteredPaths() {
            return this.handlers.keySet();
        }

        private String getBasePath(URI httpURI) {
            String path = httpURI.getPath();
            if (path.contains(REST_PATH_PLACEHOLDER)) {
                path = PathTemplate.create((String)path).getBase();
            }
            return URLUtils.normalizeSlashes((String)path);
        }

        private String getContextPath(URI httpURI) {
            String path = this.getBasePath(httpURI);
            String[] pathElements = path.replaceFirst("^/", "").split("/");
            if (pathElements.length > 1) {
                return String.format("/%s/%s", pathElements[0], pathElements[1]);
            }
            return String.format("/%s", pathElements[0]);
        }

        private String getRelativePath(URI httpURI, boolean matchOnUriPrefix) {
            String path = httpURI.getPath();
            String contextPath = this.getContextPath(httpURI);
            String normalizedPath = URLUtils.normalizeSlashes((String)path.substring(contextPath.length()));
            if (matchOnUriPrefix) {
                normalizedPath = normalizedPath + "*";
            }
            return normalizedPath;
        }
    }
}

