/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.undertow;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.util.Methods;
import io.undertow.util.PathTemplate;
import io.undertow.util.URLUtils;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowHost;
import org.apache.camel.component.undertow.handlers.CamelWebSocketHandler;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.camel.utils.IllegalStateAssertion;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.parser.SubsystemState;
import org.wildfly.extension.camel.service.CamelEndpointDeployerService;
import org.wildfly.extension.camel.service.CamelEndpointDeploymentSchedulerService;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;

public class CamelUndertowHostService
extends AbstractService<UndertowHost> {
    static final ServiceName SERVICE_NAME = CamelConstants.CAMEL_BASE_NAME.append(new String[]{"Undertow"});
    private final InjectedValue<SocketBinding> injectedHttpSocketBinding = new InjectedValue();
    private final InjectedValue<UndertowService> injectedUndertowService = new InjectedValue();
    private final InjectedValue<Host> injectedDefaultHost = new InjectedValue();
    private final SubsystemState.RuntimeState runtimeState;
    private UndertowEventListener eventListener;
    private UndertowHost undertowHost;

    public static ServiceController<UndertowHost> addService(ServiceTarget serviceTarget, SubsystemState.RuntimeState runtimeState) {
        CamelUndertowHostService service = new CamelUndertowHostService(runtimeState);
        ServiceBuilder builder = serviceTarget.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(UndertowService.UNDERTOW, UndertowService.class, service.injectedUndertowService);
        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{"http"}), SocketBinding.class, service.injectedHttpSocketBinding);
        builder.addDependency(UndertowService.virtualHostName((String)"default-server", (String)"default-host"), Host.class, service.injectedDefaultHost);
        return builder.install();
    }

    private CamelUndertowHostService(SubsystemState.RuntimeState runtimeState) {
        this.runtimeState = runtimeState;
    }

    public void start(StartContext startContext) throws StartException {
        this.runtimeState.setHttpHost(this.getConnectionURL());
        this.eventListener = new CamelUndertowEventListener();
        ((UndertowService)this.injectedUndertowService.getValue()).registerListener(this.eventListener);
        this.undertowHost = new WildFlyUndertowHost((Host)this.injectedDefaultHost.getValue());
    }

    private URL getConnectionURL() throws StartException {
        URL result;
        SocketBinding socketBinding = (SocketBinding)this.injectedHttpSocketBinding.getValue();
        InetAddress address = socketBinding.getNetworkInterfaceBinding().getAddress();
        try {
            String hostAddress = NetworkUtils.formatPossibleIpv6Address((String)address.getHostAddress());
            result = new URL(socketBinding.getName() + "://" + hostAddress + ":" + socketBinding.getPort());
        }
        catch (MalformedURLException ex) {
            throw new StartException((Throwable)ex);
        }
        return result;
    }

    public void stop(StopContext context) {
        ((UndertowService)this.injectedUndertowService.getValue()).unregisterListener(this.eventListener);
    }

    public UndertowHost getValue() throws IllegalStateException {
        return this.undertowHost;
    }

    class CamelUndertowEventListener
    implements UndertowEventListener {
        private final ConcurrentMap<String, Boolean> existingContextPaths = new ConcurrentHashMap<String, Boolean>();

        CamelUndertowEventListener() {
        }

        public void onDeploymentStart(Deployment dep, Host host) {
            this.checkForOverlappingContextPath(dep);
            CamelUndertowHostService.this.runtimeState.addHttpContext(dep.getServletContext().getContextPath());
        }

        public void onDeploymentStop(Deployment dep, Host host) {
            CamelUndertowHostService.this.runtimeState.removeHttpContext(dep.getServletContext().getContextPath());
            DeploymentInfo depInfo = dep.getDeploymentInfo();
            if (dep.getHandler() != null) {
                String contextPath = depInfo.getContextPath();
                this.existingContextPaths.remove(contextPath);
            }
        }

        private void checkForOverlappingContextPath(Deployment dep) {
            DeploymentInfo depInfo = dep.getDeploymentInfo();
            if (dep.getHandler() != null) {
                String contextPath = depInfo.getContextPath();
                Boolean exists = this.existingContextPaths.putIfAbsent(contextPath, Boolean.TRUE);
                IllegalStateAssertion.assertFalse((Boolean)(Boolean.TRUE == exists ? 1 : 0), (String)("Cannot overwrite context path " + contextPath + " owned by camel-undertow" + contextPath));
            }
        }
    }

    static class MethodPathValue {
        private int refCount;
        private HttpHandler handler;

        MethodPathValue() {
        }

        public HttpHandler addRef(HttpHandler handler, String method, String path) {
            if (this.handler == null) {
                this.handler = handler;
                ++this.refCount;
                return handler;
            }
            if ("OPTIONS".equals(method) || CamelWebSocketHandler.class == this.handler.getClass() && CamelWebSocketHandler.class == handler.getClass()) {
                ++this.refCount;
                return this.handler;
            }
            throw new IllegalStateException(String.format("Duplicate handler for method %s and path '%s': '%s', '%s'", method, path, this.handler, handler));
        }

        public void removeRef() {
            if (--this.refCount == 0) {
                this.handler = null;
            }
        }

        public String toString() {
            return this.handler == null ? "null" : this.handler.toString();
        }
    }

    static class MethodPathKey {
        private final String method;
        private final String path;

        private MethodPathKey(String method, String path) {
            this.method = method;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodPathKey that = (MethodPathKey)o;
            if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
                return false;
            }
            return this.path != null ? this.path.equals(that.path) : that.path == null;
        }

        public int hashCode() {
            int result = this.method != null ? this.method.hashCode() : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }

        public String toString() {
            return String.format("%s: %s", this.method, this.path);
        }
    }

    static class DelegatingRoutingHandler
    implements HttpHandler {
        private final Map<MethodPathKey, MethodPathValue> paths = new ConcurrentHashMap<MethodPathKey, MethodPathValue>();
        private final RoutingHandler delegate = Handlers.routing();
        private final ModuleClassLoader classLoader;

        public DelegatingRoutingHandler(ModuleClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HttpHandler add(String method, String path, HttpHandler handler) {
            MethodPathKey key = new MethodPathKey(method, path);
            HttpHandler result = null;
            Map<MethodPathKey, MethodPathValue> map = this.paths;
            synchronized (map) {
                MethodPathValue value = this.paths.computeIfAbsent(key, k -> new MethodPathValue());
                result = value.addRef(handler, method, path);
            }
            if (handler == result) {
                CamelLogger.LOGGER.debug("Registered paths {}", (Object)this.toString());
                this.delegate.add(method, path, handler);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(String method, String path) {
            boolean result;
            MethodPathKey key = new MethodPathKey(method, path);
            Map<MethodPathKey, MethodPathValue> map = this.paths;
            synchronized (map) {
                MethodPathValue value = this.paths.get(key);
                if (value != null) {
                    value.removeRef();
                    if (value.refCount <= 0) {
                        this.paths.remove(key);
                    }
                }
                result = this.paths.isEmpty();
            }
            this.delegate.remove(Methods.fromString((String)method), path);
            return result;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (exchange.getRelativePath().isEmpty()) {
                exchange.setRelativePath("/");
            }
            this.delegate.handleRequest(exchange);
        }

        public String toString() {
            String formattedPaths = this.paths.entrySet().stream().map(entry -> entry.toString()).collect(Collectors.joining(", "));
            return String.format("DelegatingRoutingHandler [%s]", formattedPaths);
        }
    }

    static class WildFlyUndertowHost
    implements UndertowHost {
        private static final String REST_PATH_PLACEHOLDER = "{";
        private static final String DEFAULT_METHODS = "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
        private final Map<String, DelegatingRoutingHandler> handlers = new ConcurrentHashMap<String, DelegatingRoutingHandler>();
        private final Host defaultHost;

        private static CamelEndpointDeploymentSchedulerService lookupDeploymentSchedulerService(ClassLoader tccl) {
            ServiceName serviceName = CamelEndpointDeploymentSchedulerService.deploymentSchedulerServiceName((ClassLoader)tccl);
            ServiceController serviceControler = CurrentServiceContainer.getServiceContainer().getRequiredService(serviceName);
            return (CamelEndpointDeploymentSchedulerService)serviceControler.getValue();
        }

        private static ModuleClassLoader checkTccl() {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl instanceof ModuleClassLoader && ((ModuleClassLoader)tccl).getName().startsWith("deployment.")) {
                return (ModuleClassLoader)tccl;
            }
            throw new IllegalStateException("Expected an org.jboss.modules.ModuleClassLoader with name starting with 'deployment.'; found " + tccl);
        }

        WildFlyUndertowHost(Host host) {
            this.defaultHost = host;
        }

        public void validateEndpointURI(URI httpURI) {
            this.validateEndpointPort(httpURI);
            this.validateEndpointContextPath(httpURI);
        }

        private void validateEndpointPort(URI httpURI) {
            boolean portMatched;
            boolean bl = portMatched = httpURI.getPort() == 0 || httpURI.getPort() == -1;
            if (!portMatched) {
                for (UndertowListener listener : this.defaultHost.getServer().getListeners()) {
                    SocketBinding binding = listener.getSocketBinding();
                    if (binding == null || binding.getPort() != httpURI.getPort()) continue;
                    portMatched = true;
                    break;
                }
            }
            if (!"localhost".equals(httpURI.getHost())) {
                CamelLogger.LOGGER.debug("Cannot bind to host other than 'localhost': {}", (Object)httpURI);
            }
            if (!portMatched) {
                CamelLogger.LOGGER.debug("Cannot bind to specific port: {}", (Object)httpURI);
            }
        }

        private void validateEndpointContextPath(URI httpURI) {
            String undertowEndpointPath = this.getContextPath(httpURI);
            Set deployments = this.defaultHost.getDeployments();
            for (Deployment deployment : deployments) {
                DeploymentInfo depInfo = deployment.getDeploymentInfo();
                String contextPath = depInfo.getContextPath();
                if (!contextPath.equals(undertowEndpointPath)) continue;
                HttpHandler handler = deployment.getHandler();
                if (handler instanceof CamelEndpointDeployerService.CamelEndpointDeployerHandler && ((CamelEndpointDeployerService.CamelEndpointDeployerHandler)handler).getRoutingHandler() instanceof DelegatingRoutingHandler) {
                    ModuleClassLoader oldCl = ((DelegatingRoutingHandler)((CamelEndpointDeployerService.CamelEndpointDeployerHandler)handler).getRoutingHandler()).classLoader;
                    ModuleClassLoader tccl = WildFlyUndertowHost.checkTccl();
                    if (tccl == oldCl) continue;
                    throw new IllegalStateException("Cannot add " + HttpHandler.class.getName() + " for path " + contextPath + " defined in " + tccl.getName() + " because that path is already served by " + oldCl.getName());
                }
                throw new IllegalStateException("Cannot overwrite context path " + contextPath + " owned by " + depInfo.getDeploymentName());
            }
        }

        public HttpHandler registerHandler(HttpHandlerRegistrationInfo reginfo, HttpHandler handler) {
            boolean matchOnUriPrefix = reginfo.isMatchOnUriPrefix();
            URI httpURI = reginfo.getUri();
            String contextPath = this.getContextPath(httpURI);
            CamelLogger.LOGGER.debug("Using context path {}", (Object)contextPath);
            String relativePath = this.getRelativePath(httpURI, matchOnUriPrefix);
            CamelLogger.LOGGER.debug("Using relative path {}", (Object)relativePath);
            boolean registerRoutingHandler = false;
            DelegatingRoutingHandler routingHandler = this.handlers.get(contextPath);
            if (routingHandler == null) {
                routingHandler = new DelegatingRoutingHandler(WildFlyUndertowHost.checkTccl());
                registerRoutingHandler = true;
                this.handlers.put(contextPath, routingHandler);
                CamelLogger.LOGGER.debug("Created new DelegatingRoutingHandler {}", (Object)routingHandler);
            }
            String methods = reginfo.getMethodRestrict() == null ? DEFAULT_METHODS : reginfo.getMethodRestrict();
            CamelLogger.LOGGER.debug("Using methods {}", (Object)methods);
            HttpHandler result = null;
            for (String method : methods.split(",")) {
                CamelLogger.LOGGER.debug("Adding {}: {} for handler {}", new Object[]{method, relativePath, handler});
                result = routingHandler.add(method, relativePath, handler);
            }
            if (registerRoutingHandler) {
                WildFlyUndertowHost.lookupDeploymentSchedulerService((ClassLoader)routingHandler.classLoader).schedule(httpURI.resolve(contextPath), (HttpHandler)routingHandler);
            }
            return result;
        }

        public void unregisterHandler(HttpHandlerRegistrationInfo reginfo) {
            boolean matchOnUriPrefix = reginfo.isMatchOnUriPrefix();
            URI httpURI = reginfo.getUri();
            String contextPath = this.getContextPath(httpURI);
            CamelLogger.LOGGER.debug("unregisterHandler {}", (Object)contextPath);
            DelegatingRoutingHandler routingHandler = this.handlers.get(contextPath);
            if (routingHandler != null) {
                String methods = reginfo.getMethodRestrict() == null ? DEFAULT_METHODS : reginfo.getMethodRestrict();
                boolean routingHandlerEmpty = false;
                for (String method : methods.split(",")) {
                    String relativePath = this.getRelativePath(httpURI, matchOnUriPrefix);
                    routingHandlerEmpty = routingHandler.remove(method, relativePath);
                    CamelLogger.LOGGER.debug("Unregistered {}: {}", (Object)method, (Object)relativePath);
                }
                if (routingHandlerEmpty) {
                    WildFlyUndertowHost.lookupDeploymentSchedulerService((ClassLoader)routingHandler.classLoader).unschedule(httpURI.resolve(contextPath));
                    this.handlers.remove(contextPath);
                    CamelLogger.LOGGER.debug("Unregistered root handler from {}", (Object)contextPath);
                }
            }
        }

        private String getBasePath(URI httpURI) {
            String path = httpURI.getPath();
            if (path.contains(REST_PATH_PLACEHOLDER)) {
                path = PathTemplate.create((String)path).getBase();
            }
            return URLUtils.normalizeSlashes((String)path);
        }

        private String getContextPath(URI httpURI) {
            String path = this.getBasePath(httpURI);
            String[] pathElements = path.replaceFirst("^/", "").split("/");
            if (pathElements.length > 1) {
                return String.format("/%s/%s", pathElements[0], pathElements[1]);
            }
            return String.format("/%s", pathElements[0]);
        }

        private String getRelativePath(URI httpURI, boolean matchOnUriPrefix) {
            String path = httpURI.getPath();
            String contextPath = this.getContextPath(httpURI);
            String normalizedPath = URLUtils.normalizeSlashes((String)path.substring(contextPath.length()));
            if (matchOnUriPrefix) {
                normalizedPath = normalizedPath + "*";
            }
            return normalizedPath;
        }
    }
}

