/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.camel.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.wildfly.swarm.camel.generator.FractionsGenerator;
import org.wildfly.swarm.camel.generator.Options;

public class Main {
    public static void main(String[] args) {
        try {
            new Main().process(args);
        }
        catch (Throwable th) {
            Runtime.getRuntime().exit(1);
        }
    }

    public void process(String[] args) throws Throwable {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException ex) {
            Main.helpScreen(parser);
            throw ex;
        }
        try {
            this.generate(options.outpath);
        }
        catch (Throwable th) {
            FractionsGenerator.LOG.error("Error executing command", th);
            throw th;
        }
    }

    private void generate(Path outpath) throws IOException {
        FractionsGenerator tool = new FractionsGenerator(outpath);
        tool.generate();
    }

    private static void helpScreen(CmdLineParser cmdParser) {
        cmdParser.printUsage((OutputStream)System.err);
    }
}

