/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.channel.Channel;
import org.wildfly.channel.InvalidChannelException;

public class ChannelMapper {
    public static final String SCHEMA_VERSION_1_0_0 = "1.0.0";
    public static final String CURRENT_SCHEMA_VERSION = "1.0.0";
    private static final String SCHEMA_1_0_0_FILE = "org/wildfly/channel/v1.0.0/schema.json";
    private static final YAMLFactory YAML_FACTORY = new YAMLFactory();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)YAML_FACTORY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final JsonSchemaFactory SCHEMA_FACTORY = JsonSchemaFactory.builder((JsonSchemaFactory)JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909)).objectMapper(OBJECT_MAPPER).build();
    private static final Map<String, JsonSchema> SCHEMAS = new HashMap<String, JsonSchema>();

    private static JsonSchema getSchema(JsonNode node) {
        JsonNode schemaVersion = node.path("schemaVersion");
        String version = schemaVersion.asText();
        if (version == null || version.isEmpty()) {
            throw new RuntimeException("The channel does not specify a schemaVersion.");
        }
        JsonSchema schema = SCHEMAS.get(version);
        if (schema == null) {
            throw new RuntimeException("Unknown schema version " + schemaVersion);
        }
        return schema;
    }

    public static String toYaml(Channel ... channels) throws IOException {
        return ChannelMapper.toYaml(Arrays.asList(channels));
    }

    public static String toYaml(List<Channel> channels) throws IOException {
        Objects.requireNonNull(channels);
        StringWriter w = new StringWriter();
        for (Channel channel : channels) {
            OBJECT_MAPPER.writeValue((Writer)w, (Object)channel);
        }
        return w.toString();
    }

    public static Channel from(URL channelURL) throws InvalidChannelException {
        Objects.requireNonNull(channelURL);
        try {
            List<String> messages;
            if (channelURL.toString().endsWith("/")) {
                channelURL = channelURL.toURI().resolve("channel.yaml").toURL();
            }
            if (!(messages = ChannelMapper.validate(channelURL)).isEmpty()) {
                throw new InvalidChannelException("Invalid channel", messages);
            }
            Channel channel = (Channel)OBJECT_MAPPER.readValue(channelURL, Channel.class);
            return channel;
        }
        catch (IOException | URISyntaxException e) {
            throw ChannelMapper.wrapException(e);
        }
    }

    public static List<Channel> fromString(String yamlContent) throws InvalidChannelException {
        Objects.requireNonNull(yamlContent);
        try {
            List<String> messages = ChannelMapper.validateString(yamlContent);
            if (!messages.isEmpty()) {
                throw new InvalidChannelException("Invalid channel", messages);
            }
            YAMLParser parser = YAML_FACTORY.createParser(yamlContent);
            List channels = OBJECT_MAPPER.readValues((JsonParser)parser, Channel.class).readAll();
            return channels;
        }
        catch (IOException e) {
            throw ChannelMapper.wrapException(e);
        }
    }

    private static List<String> validate(URL url) throws IOException {
        JsonNode node = OBJECT_MAPPER.readTree(url);
        JsonSchema schema = ChannelMapper.getSchema(node);
        Set validationMessages = schema.validate(node);
        return validationMessages.stream().map(ValidationMessage::getMessage).collect(Collectors.toList());
    }

    private static List<String> validateString(String yamlContent) throws IOException {
        JsonNode node = OBJECT_MAPPER.readTree(yamlContent);
        JsonSchema schema = ChannelMapper.getSchema(node);
        Set validationMessages = schema.validate(node);
        return validationMessages.stream().map(ValidationMessage::getMessage).collect(Collectors.toList());
    }

    private static InvalidChannelException wrapException(Exception e) {
        InvalidChannelException ice = new InvalidChannelException("Invalid Channel", Collections.singletonList(e.getLocalizedMessage()));
        ice.initCause(e);
        return ice;
    }

    static {
        SCHEMAS.put("1.0.0", SCHEMA_FACTORY.getSchema(ChannelMapper.class.getClassLoader().getResourceAsStream(SCHEMA_1_0_0_FILE)));
    }
}

