/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelRecorder;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.spi.MavenVersionsResolver;

public class ChannelSession
implements AutoCloseable {
    private final List<Channel> channels;
    private final ChannelRecorder recorder = new ChannelRecorder();
    private final MavenVersionsResolver resolver;

    public ChannelSession(List<Channel> channels, MavenVersionsResolver.Factory factory) {
        Objects.requireNonNull(channels);
        Objects.requireNonNull(factory);
        this.resolver = factory.create();
        this.channels = channels;
        for (Channel channel : channels) {
            channel.init(factory);
        }
    }

    public MavenArtifact resolveMavenArtifact(String groupId, String artifactId, String extension, String classifier, String baseVersion) throws UnresolvedMavenArtifactException {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Channel.ResolveLatestVersionResult result = this.findChannelWithLatestVersion(groupId, artifactId, extension, classifier, baseVersion);
        String latestVersion = result.version;
        Channel channel = result.channel;
        Channel.ResolveArtifactResult artifact = channel.resolveArtifact(groupId, artifactId, extension, classifier, latestVersion);
        this.recorder.recordStream(groupId, artifactId, latestVersion);
        return new MavenArtifact(groupId, artifactId, extension, classifier, latestVersion, artifact.file);
    }

    public MavenArtifact resolveDirectMavenArtifact(String groupId, String artifactId, String extension, String classifier, String version) throws UnresolvedMavenArtifactException {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(version);
        File file = this.resolver.resolveArtifact(groupId, artifactId, extension, classifier, version);
        this.recorder.recordStream(groupId, artifactId, version);
        return new MavenArtifact(groupId, artifactId, extension, classifier, version, file);
    }

    public String findLatestMavenArtifactVersion(String groupId, String artifactId, String extension, String classifier, String baseVersion) throws UnresolvedMavenArtifactException {
        return this.findChannelWithLatestVersion((String)groupId, (String)artifactId, (String)extension, (String)classifier, (String)baseVersion).version;
    }

    @Override
    public void close() {
        for (Channel channel : this.channels) {
            channel.close();
        }
        this.resolver.close();
    }

    public Channel getRecordedChannel() {
        return this.recorder.getRecordedChannel();
    }

    private Channel.ResolveLatestVersionResult findChannelWithLatestVersion(String groupId, String artifactId, String extension, String classifier, String baseVersion) throws UnresolvedMavenArtifactException {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        for (Channel channel : this.channels) {
            Optional<Channel.ResolveLatestVersionResult> result = channel.resolveLatestVersion(groupId, artifactId, extension, classifier);
            if (!result.isPresent()) continue;
            return result.get();
        }
        throw new UnresolvedMavenArtifactException(String.format("Can not resolve latest Maven artifact (no stream found) : %s:%s:%s:%s", groupId, artifactId, extension, classifier));
    }
}

