/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelRecorder;
import org.wildfly.channel.MavenArtifact;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channel.version.VersionMatcher;

public class ChannelSession
implements AutoCloseable {
    private final List<Channel> channels;
    private final ChannelRecorder recorder = new ChannelRecorder();
    private final MavenVersionsResolver resolver;

    public ChannelSession(List<Channel> channels, MavenVersionsResolver.Factory factory) {
        Objects.requireNonNull(channels);
        Objects.requireNonNull(factory);
        this.resolver = factory.create();
        this.channels = channels;
        for (Channel channel : channels) {
            channel.init(factory);
        }
    }

    public MavenArtifact resolveMavenArtifact(String groupId, String artifactId, String extension, String classifier, String baseVersion) throws UnresolvedMavenArtifactException {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Channel.ResolveLatestVersionResult result = this.findChannelWithLatestVersion(groupId, artifactId, extension, classifier, baseVersion);
        String latestVersion = result.version;
        Channel channel = result.channel;
        Channel.ResolveArtifactResult artifact = channel.resolveArtifact(groupId, artifactId, extension, classifier, latestVersion);
        this.recorder.recordStream(groupId, artifactId, latestVersion);
        return new MavenArtifact(groupId, artifactId, extension, classifier, latestVersion, artifact.file);
    }

    public List<MavenArtifact> resolveMavenArtifacts(List<ArtifactCoordinate> coordinates) throws UnresolvedMavenArtifactException {
        Objects.requireNonNull(coordinates);
        Map<Channel, List<ArtifactCoordinate>> channelMap = this.splitArtifactsPerChannel(coordinates);
        ArrayList<MavenArtifact> res = new ArrayList<MavenArtifact>();
        for (Channel channel : channelMap.keySet()) {
            List<ArtifactCoordinate> requests = channelMap.get(channel);
            List<Channel.ResolveArtifactResult> resolveArtifactResults = channel.resolveArtifacts(requests);
            for (int i = 0; i < requests.size(); ++i) {
                ArtifactCoordinate request = requests.get(i);
                MavenArtifact resolvedArtifact = new MavenArtifact(request.getGroupId(), request.getArtifactId(), request.getExtension(), request.getClassifier(), request.getVersion(), resolveArtifactResults.get((int)i).file);
                this.recorder.recordStream(resolvedArtifact.getGroupId(), resolvedArtifact.getArtifactId(), resolvedArtifact.getVersion());
                res.add(resolvedArtifact);
            }
        }
        return res;
    }

    public MavenArtifact resolveDirectMavenArtifact(String groupId, String artifactId, String extension, String classifier, String version) throws UnresolvedMavenArtifactException {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(version);
        File file = this.resolver.resolveArtifact(groupId, artifactId, extension, classifier, version);
        this.recorder.recordStream(groupId, artifactId, version);
        return new MavenArtifact(groupId, artifactId, extension, classifier, version, file);
    }

    public List<MavenArtifact> resolveDirectMavenArtifacts(List<ArtifactCoordinate> coordinates) throws UnresolvedMavenArtifactException {
        coordinates.stream().forEach(c -> {
            Objects.requireNonNull(c.getGroupId());
            Objects.requireNonNull(c.getArtifactId());
            Objects.requireNonNull(c.getVersion());
        });
        List<File> files = this.resolver.resolveArtifacts(coordinates);
        ArrayList<MavenArtifact> res = new ArrayList<MavenArtifact>();
        for (int i = 0; i < coordinates.size(); ++i) {
            ArtifactCoordinate request = coordinates.get(i);
            MavenArtifact resolvedArtifact = new MavenArtifact(request.getGroupId(), request.getArtifactId(), request.getExtension(), request.getClassifier(), request.getVersion(), files.get(i));
            this.recorder.recordStream(resolvedArtifact.getGroupId(), resolvedArtifact.getArtifactId(), resolvedArtifact.getVersion());
            res.add(resolvedArtifact);
        }
        return res;
    }

    public String findLatestMavenArtifactVersion(String groupId, String artifactId, String extension, String classifier, String baseVersion) throws UnresolvedMavenArtifactException {
        return this.findChannelWithLatestVersion((String)groupId, (String)artifactId, (String)extension, (String)classifier, (String)baseVersion).version;
    }

    @Override
    public void close() {
        for (Channel channel : this.channels) {
            channel.close();
        }
        this.resolver.close();
    }

    public Channel getRecordedChannel() {
        return this.recorder.getRecordedChannel();
    }

    private Channel.ResolveLatestVersionResult findChannelWithLatestVersion(String groupId, String artifactId, String extension, String classifier, String baseVersion) throws UnresolvedMavenArtifactException {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        HashMap<String, Channel.ResolveLatestVersionResult> foundVersions = new HashMap<String, Channel.ResolveLatestVersionResult>();
        for (Channel channel : this.channels) {
            Optional<Channel.ResolveLatestVersionResult> result = channel.resolveLatestVersion(groupId, artifactId, extension, classifier);
            if (!result.isPresent()) continue;
            foundVersions.put(result.get().version, result.get());
        }
        Optional<String> foundLatestVersionInChannels = foundVersions.keySet().stream().sorted(VersionMatcher.COMPARATOR.reversed()).findFirst();
        return (Channel.ResolveLatestVersionResult)foundVersions.get(foundLatestVersionInChannels.orElseThrow(() -> {
            throw new UnresolvedMavenArtifactException(String.format("Can not resolve latest Maven artifact (no stream found) : %s:%s:%s:%s", groupId, artifactId, extension, classifier));
        }));
    }

    private Map<Channel, List<ArtifactCoordinate>> splitArtifactsPerChannel(List<ArtifactCoordinate> coordinates) {
        HashMap<Channel, List<ArtifactCoordinate>> channelMap = new HashMap<Channel, List<ArtifactCoordinate>>();
        for (ArtifactCoordinate coord : coordinates) {
            Channel.ResolveLatestVersionResult result = this.findChannelWithLatestVersion(coord.getGroupId(), coord.getArtifactId(), coord.getExtension(), coord.getClassifier(), coord.getVersion());
            ArtifactCoordinate query = new ArtifactCoordinate(coord.getGroupId(), coord.getArtifactId(), coord.getExtension(), coord.getClassifier(), result.version);
            Channel channel = result.channel;
            if (!channelMap.containsKey(channel)) {
                channelMap.put(channel, new ArrayList());
            }
            ((List)channelMap.get(channel)).add(query);
        }
        return channelMap;
    }
}

