/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import java.io.File;
import java.util.Objects;
import org.wildfly.channel.ArtifactCoordinate;

public class MavenArtifact
extends ArtifactCoordinate {
    private final File file;

    public MavenArtifact(String groupId, String artifactId, String extension, String classifier, String version, File file) {
        super(groupId, artifactId, extension, classifier, version);
        Objects.requireNonNull(file);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String toString() {
        return "MavenArtifact{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', extension='" + this.extension + "', classifier='" + this.classifier + "', version='" + this.version + "', file=" + this.file + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifact artifact = (MavenArtifact)o;
        return Objects.equals(this.file, artifact.file) && Objects.equals(this.groupId, artifact.groupId) && Objects.equals(this.artifactId, artifact.artifactId) && Objects.equals(this.extension, artifact.extension) && Objects.equals(this.classifier, artifact.classifier) && Objects.equals(this.version, artifact.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.file, this.groupId, this.artifactId, this.extension, this.classifier, this.version);
    }
}

