/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import java.net.URL;
import java.util.Objects;

public class ChannelMetadataCoordinate {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String extension;
    private URL url;

    protected ChannelMetadataCoordinate() {
    }

    public ChannelMetadataCoordinate(String groupId, String artifactId, String version, String classifier, String extension) {
        this(groupId, artifactId, version, classifier, extension, null);
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(version);
    }

    public ChannelMetadataCoordinate(String groupId, String artifactId, String classifier, String extension) {
        this(groupId, artifactId, null, classifier, extension, null);
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
    }

    public ChannelMetadataCoordinate(URL url) {
        this(null, null, null, null, null, url);
        Objects.requireNonNull(url);
    }

    private ChannelMetadataCoordinate(String groupId, String artifactId, String version, String classifier, String extension, URL url) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
        this.url = url;
    }

    protected ChannelMetadataCoordinate(String classifier, String extension) {
        this(null, null, null, classifier, extension, null);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelMetadataCoordinate that = (ChannelMetadataCoordinate)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.extension, that.extension) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.extension, this.url);
    }
}

