/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.MavenCoordinate;

@JsonIgnoreProperties(value={"groupId", "artifactId", "version", "classifier", "extension"})
public class ChannelManifestCoordinate
extends ChannelMetadataCoordinate {
    public ChannelManifestCoordinate(String groupId, String artifactId, String version) {
        super(groupId, artifactId, version, "manifest", "yaml");
    }

    public ChannelManifestCoordinate(String groupId, String artifactId) {
        super(groupId, artifactId, "manifest", "yaml");
    }

    public ChannelManifestCoordinate(URL url) {
        super(url);
    }

    public ChannelManifestCoordinate(URL url, URL signatureUrl) {
        super(url, signatureUrl);
    }

    public ChannelManifestCoordinate() {
        super("manifest", "yaml");
    }

    public static ChannelManifestCoordinate create(String url, MavenCoordinate gav) throws MalformedURLException {
        return ChannelManifestCoordinate.create(url, null, gav);
    }

    @JsonCreator
    public static ChannelManifestCoordinate create(@JsonProperty(value="url") String url, @JsonProperty(value="signature-url") String signatureUrl, @JsonProperty(value="maven") MavenCoordinate gav) throws MalformedURLException {
        if (gav != null) {
            if (gav.getVersion() == null || gav.getVersion().isEmpty()) {
                return new ChannelManifestCoordinate(gav.getGroupId(), gav.getArtifactId());
            }
            return new ChannelManifestCoordinate(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
        }
        return new ChannelManifestCoordinate(new URL(url), signatureUrl == null ? null : new URL(signatureUrl));
    }

    @JsonProperty(value="maven")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MavenCoordinate getMaven() {
        if (this.isEmpty(this.getGroupId()) || this.isEmpty(this.getArtifactId())) {
            return null;
        }
        return new MavenCoordinate(this.getGroupId(), this.getArtifactId(), this.getVersion());
    }

    private boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    @Override
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public URL getUrl() {
        return super.getUrl();
    }

    @Override
    @JsonProperty(value="signature-url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public URL getSignatureUrl() {
        return super.getSignatureUrl();
    }
}

