/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.wildfly.channel.MavenCoordinate;

public class ManifestRequirement {
    private final String id;
    private final MavenCoordinate mavenCoordinate;

    @JsonCreator
    public ManifestRequirement(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="maven") MavenCoordinate mavenCoordinate) {
        Objects.requireNonNull(id);
        this.id = id;
        this.mavenCoordinate = mavenCoordinate;
    }

    public String getId() {
        return this.id;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="maven")
    public MavenCoordinate getMavenCoordinate() {
        return this.mavenCoordinate;
    }

    @JsonIgnore
    public String getGroupId() {
        return this.mavenCoordinate == null ? null : this.mavenCoordinate.getGroupId();
    }

    @JsonIgnore
    public String getArtifactId() {
        return this.mavenCoordinate == null ? null : this.mavenCoordinate.getArtifactId();
    }

    @JsonIgnore
    public String getVersion() {
        return this.mavenCoordinate == null ? null : this.mavenCoordinate.getVersion();
    }

    public String toString() {
        return "ManifestRequirement{id='" + this.id + "', mavenCoordinate=" + String.valueOf(this.mavenCoordinate) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestRequirement that = (ManifestRequirement)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.mavenCoordinate, that.mavenCoordinate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.mavenCoordinate);
    }
}

