/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.ArtifactTransferException;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.InvalidChannelMetadataException;
import org.wildfly.channel.Repository;
import org.wildfly.channel.spi.ArtifactIdentifier;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channel.spi.SignatureResult;
import org.wildfly.channel.spi.SignatureValidator;
import org.wildfly.channel.version.VersionMatcher;

public class SignedVersionResolverWrapper
implements MavenVersionsResolver {
    protected static final String SIGNATURE_FILE_SUFFIX = ".asc";
    private final MavenVersionsResolver wrapped;
    private final SignatureValidator signatureValidator;
    private final List<String> gpgUrls;
    private final Collection<Repository> repositories;

    public SignedVersionResolverWrapper(MavenVersionsResolver wrapped, Collection<Repository> repositories, SignatureValidator signatureValidator, List<String> gpgUrls) {
        this.wrapped = wrapped;
        this.repositories = repositories;
        this.signatureValidator = signatureValidator;
        this.gpgUrls = gpgUrls;
    }

    private void validateGpgSignature(String groupId, String artifactId, String extension, String classifier, String version, File artifact) {
        ArtifactIdentifier.MavenResource mavenArtifact = new ArtifactIdentifier.MavenResource(groupId, artifactId, extension, classifier, version);
        try {
            File signature = this.wrapped.resolveArtifact(groupId, artifactId, extension + SIGNATURE_FILE_SUFFIX, classifier, version);
            SignatureResult signatureResult = this.signatureValidator.validateSignature(mavenArtifact, new FileInputStream(artifact), new FileInputStream(signature), this.gpgUrls);
            if (signatureResult.getResult() != SignatureResult.Result.OK) {
                throw new SignatureValidator.SignatureException("Failed to verify an artifact signature", signatureResult);
            }
        }
        catch (FileNotFoundException | ArtifactTransferException e) {
            throw new SignatureValidator.SignatureException("Unable to find required signature for " + String.valueOf(mavenArtifact), e, SignatureResult.noSignature(mavenArtifact));
        }
    }

    private void validateGpgSignature(URL artifactFile, URL signature) throws IOException {
        SignatureResult signatureResult = this.signatureValidator.validateSignature(new ArtifactIdentifier.UrlResource(artifactFile), artifactFile.openStream(), signature.openStream(), this.gpgUrls);
        if (signatureResult.getResult() != SignatureResult.Result.OK) {
            throw new SignatureValidator.SignatureException("Failed to verify an artifact signature", signatureResult);
        }
    }

    @Override
    public Set<String> getAllVersions(String groupId, String artifactId, String extension, String classifier) {
        return this.wrapped.getAllVersions(groupId, artifactId, extension, classifier);
    }

    @Override
    public File resolveArtifact(String groupId, String artifactId, String extension, String classifier, String version) throws ArtifactTransferException {
        File artifact = this.wrapped.resolveArtifact(groupId, artifactId, extension, classifier, version);
        this.validateGpgSignature(groupId, artifactId, extension, classifier, version, artifact);
        return artifact;
    }

    @Override
    public List<File> resolveArtifacts(List<ArtifactCoordinate> coordinates) throws ArtifactTransferException {
        List<File> resolvedArtifacts = this.wrapped.resolveArtifacts(coordinates);
        try {
            List<File> signatures = this.wrapped.resolveArtifacts(coordinates.stream().map(c -> new ArtifactCoordinate(c.getGroupId(), c.getArtifactId(), c.getExtension() + SIGNATURE_FILE_SUFFIX, c.getClassifier(), c.getVersion())).collect(Collectors.toList()));
            for (int i = 0; i < resolvedArtifacts.size(); ++i) {
                File artifact = resolvedArtifacts.get(i);
                ArtifactCoordinate c2 = coordinates.get(i);
                ArtifactIdentifier.MavenResource mavenArtifact = new ArtifactIdentifier.MavenResource(c2.getGroupId(), c2.getArtifactId(), c2.getExtension(), c2.getClassifier(), c2.getVersion());
                File signature = signatures.get(i);
                try {
                    SignatureResult signatureResult = this.signatureValidator.validateSignature(mavenArtifact, new FileInputStream(artifact), new FileInputStream(signature), this.gpgUrls);
                    if (signatureResult.getResult() == SignatureResult.Result.OK) continue;
                    throw new SignatureValidator.SignatureException("Failed to verify an artifact signature", signatureResult);
                }
                catch (FileNotFoundException e) {
                    throw new SignatureValidator.SignatureException(String.format("Unable to find required signature for %s:%s:%s", mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion()), SignatureResult.noSignature(mavenArtifact));
                }
            }
        }
        catch (ArtifactTransferException e) {
            ArtifactIdentifier.MavenResource artifact = new ArtifactIdentifier.MavenResource((ArtifactCoordinate)e.getUnresolvedArtifacts().stream().findFirst().get());
            throw new SignatureValidator.SignatureException(String.format("Unable to find required signature for %s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), SignatureResult.noSignature(artifact));
        }
        return resolvedArtifacts;
    }

    @Override
    public List<URL> resolveChannelMetadata(List<? extends ChannelMetadataCoordinate> coords) throws ArtifactTransferException {
        Objects.requireNonNull(coords);
        List<URL> resolvedMetadata = this.wrapped.resolveChannelMetadata(coords);
        ArrayList<URL> signatures = new ArrayList<URL>();
        for (ChannelMetadataCoordinate channelMetadataCoordinate : coords) {
            if (channelMetadataCoordinate.getUrl() != null) {
                try {
                    URL signatureUrl = channelMetadataCoordinate.getSignatureUrl() == null ? new URL(channelMetadataCoordinate.getUrl().toExternalForm() + SIGNATURE_FILE_SUFFIX) : channelMetadataCoordinate.getSignatureUrl();
                    signatures.add(signatureUrl);
                    continue;
                }
                catch (IOException e) {
                    throw new InvalidChannelMetadataException("Unable to download a detached signature file from: " + channelMetadataCoordinate.getUrl().toExternalForm() + SIGNATURE_FILE_SUFFIX, List.of(e.getMessage()), e);
                }
            }
            String version = channelMetadataCoordinate.getVersion();
            if (version == null) {
                Set<String> versions = this.wrapped.getAllVersions(channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId(), channelMetadataCoordinate.getExtension(), channelMetadataCoordinate.getClassifier());
                Optional<String> latestVersion = VersionMatcher.getLatestVersion(versions);
                if (latestVersion.isPresent()) {
                    version = latestVersion.get();
                } else {
                    throw new ArtifactTransferException(String.format("Unable to resolve the latest version of channel metadata signature %s:%s", channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId()), Collections.singleton(new ArtifactCoordinate(channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId(), channelMetadataCoordinate.getExtension(), channelMetadataCoordinate.getClassifier(), "")), this.attemptedRepositories());
                }
            }
            try {
                File channelArtifact = this.wrapped.resolveArtifact(channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId(), channelMetadataCoordinate.getExtension() + SIGNATURE_FILE_SUFFIX, channelMetadataCoordinate.getClassifier(), version);
                signatures.add(channelArtifact.toURI().toURL());
            }
            catch (ArtifactTransferException e) {
                throw new SignatureValidator.SignatureException("Unable to find required signature for " + String.valueOf(channelMetadataCoordinate), e, SignatureResult.noSignature(new ArtifactIdentifier.MavenResource(channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId(), channelMetadataCoordinate.getExtension(), channelMetadataCoordinate.getClassifier(), version)));
            }
            catch (MalformedURLException e) {
                throw new ArtifactTransferException(String.format("Unable to resolve the latest version of channel metadata signature %s:%s", channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId()), (Throwable)e, Collections.singleton(new ArtifactCoordinate(channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId(), channelMetadataCoordinate.getExtension(), channelMetadataCoordinate.getClassifier(), channelMetadataCoordinate.getVersion())), this.attemptedRepositories());
            }
        }
        try {
            for (int i = 0; i < resolvedMetadata.size(); ++i) {
                this.validateGpgSignature(resolvedMetadata.get(i), (URL)signatures.get(i));
            }
        }
        catch (IOException e) {
            throw new InvalidChannelMetadataException("Unable to read a detached signature file from: " + String.valueOf(signatures), List.of(e.getMessage()), e);
        }
        return resolvedMetadata;
    }

    private Set<Repository> attemptedRepositories() {
        return this.repositories.stream().map(r -> new Repository(r.getId(), r.getUrl())).collect(Collectors.toSet());
    }

    @Override
    public String getMetadataReleaseVersion(String groupId, String artifactId) {
        return this.wrapped.getMetadataReleaseVersion(groupId, artifactId);
    }

    @Override
    public String getMetadataLatestVersion(String groupId, String artifactId) {
        return this.wrapped.getMetadataLatestVersion(groupId, artifactId);
    }
}

