/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.networknt.schema.JsonSchema;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.wildfly.channel.version.VersionMatcher;

abstract class VersionedMapper {
    private static final Logger LOG = Logger.getLogger((String)VersionedMapper.class.getName());

    VersionedMapper() {
    }

    protected static JsonSchema getSchema(String version, Map<String, JsonSchema> schemas) {
        if (schemas.containsKey(version)) {
            return schemas.get(version);
        }
        Pattern versionPattern = Pattern.compile(version.substring(0, version.lastIndexOf(46) + 1).replace(".", "\\.") + ".*");
        Optional<String> latestVersion = schemas.keySet().stream().filter(v -> versionPattern.matcher((CharSequence)v).matches()).max(VersionMatcher.COMPARATOR);
        if (latestVersion.isPresent()) {
            LOG.warnf("The schema version [%s] is not supported. The latest supported version is [%s], some features might be ignored.", (Object)version, (Object)latestVersion.get());
            return schemas.get(latestVersion.get());
        }
        return null;
    }
}

