/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.spi;

import java.io.InputStream;
import java.util.List;
import org.wildfly.channel.spi.ArtifactIdentifier;
import org.wildfly.channel.spi.SignatureResult;

public interface SignatureValidator {
    public static final SignatureValidator REJECTING_VALIDATOR = (artifactSource, artifactStream, signatureStream, gpgUrls) -> {
        throw new SignatureException("Not implemented", SignatureResult.noSignature(artifactSource));
    };

    public SignatureResult validateSignature(ArtifactIdentifier var1, InputStream var2, InputStream var3, List<String> var4) throws SignatureException;

    public static class SignatureException
    extends RuntimeException {
        private final SignatureResult signatureResult;
        private String missingSignature;

        public SignatureException(String message, Throwable cause, SignatureResult signatureResult) {
            super(SignatureException.buildErrorMessage(message, signatureResult), cause);
            this.signatureResult = signatureResult;
            this.missingSignature = signatureResult.getKeyId();
        }

        public SignatureException(String message, SignatureResult signatureResult) {
            super(SignatureException.buildErrorMessage(message, signatureResult));
            this.signatureResult = signatureResult;
            this.missingSignature = signatureResult.getKeyId();
        }

        private static String buildErrorMessage(String message, SignatureResult signatureResult) {
            return String.format("%s: %s%s", new Object[]{message, signatureResult.getResult(), signatureResult.getMessage() == null ? "" : signatureResult.getResult()});
        }

        public SignatureResult getSignatureResult() {
            return this.signatureResult;
        }

        public String getMissingSignature() {
            return this.missingSignature;
        }
    }
}

