/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.MalformedURLException;
import java.net.URL;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.MavenCoordinate;

@JsonIgnoreProperties(value={"groupId", "artifactId", "version", "classifier", "extension"})
public class BlocklistCoordinate
extends ChannelMetadataCoordinate {
    public static String CLASSIFIER = "blocklist";
    public static String EXTENSION = "yaml";

    public BlocklistCoordinate(String groupId, String artifactId) {
        super(groupId, artifactId, CLASSIFIER, EXTENSION);
    }

    public BlocklistCoordinate(String groupId, String artifactId, String version) {
        super(groupId, artifactId, version, CLASSIFIER, EXTENSION);
    }

    public BlocklistCoordinate(URL url) {
        super(url);
    }

    public BlocklistCoordinate() {
        super(CLASSIFIER, EXTENSION);
    }

    @JsonCreator
    public static BlocklistCoordinate create(@JsonProperty(value="maven") MavenCoordinate coord, @JsonProperty(value="url") String url) throws MalformedURLException {
        if (coord != null) {
            if (coord.getVersion() == null || coord.getVersion().isEmpty()) {
                return new BlocklistCoordinate(coord.getGroupId(), coord.getArtifactId());
            }
            return new BlocklistCoordinate(coord.getGroupId(), coord.getArtifactId(), coord.getVersion());
        }
        return new BlocklistCoordinate(new URL(url));
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public URL getUrl() {
        return super.getUrl();
    }

    @JsonProperty(value="maven")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MavenCoordinate getMaven() {
        if (this.getUrl() == null) {
            return new MavenCoordinate(this.getGroupId(), this.getArtifactId(), this.getVersion());
        }
        return null;
    }
}

