/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.spi;

import java.net.URL;
import org.wildfly.channel.ArtifactCoordinate;

public interface ArtifactIdentifier {
    public String getDescription();

    default public boolean isMavenResource() {
        return this instanceof MavenResource;
    }

    public static class MavenResource
    extends ArtifactCoordinate
    implements ArtifactIdentifier {
        public MavenResource(String groupId, String artifactId, String extension, String classifier, String version) {
            super(groupId, artifactId, extension, classifier, version);
        }

        public MavenResource(ArtifactCoordinate artifactCoordinate) {
            super(artifactCoordinate.getGroupId(), artifactCoordinate.getArtifactId(), artifactCoordinate.getExtension(), artifactCoordinate.getClassifier(), artifactCoordinate.getVersion());
        }

        @Override
        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.groupId).append(":").append(this.artifactId).append(":");
            if (this.classifier != null && !this.classifier.isEmpty()) {
                sb.append(this.classifier).append(":");
            }
            if (this.extension != null && !this.extension.isEmpty()) {
                sb.append(this.extension).append(":");
            }
            sb.append(this.version);
            return sb.toString();
        }
    }

    public static class UrlResource
    implements ArtifactIdentifier {
        private final URL resourceUrl;

        public UrlResource(URL resourceUrl) {
            this.resourceUrl = resourceUrl;
        }

        public URL getResourceUrl() {
            return this.resourceUrl;
        }

        @Override
        public String getDescription() {
            return this.resourceUrl.toExternalForm();
        }
    }
}

