/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.spi;

import org.wildfly.channel.spi.ArtifactIdentifier;

public class SignatureResult {
    private ArtifactIdentifier resource;
    private String keyId;
    private String message;
    private final Result result;

    public static SignatureResult noMatchingCertificate(ArtifactIdentifier resource, String keyID) {
        return new SignatureResult(Result.NO_MATCHING_CERT, resource, keyID, null);
    }

    public static SignatureResult revoked(ArtifactIdentifier resource, String keyID, String revocationReason) {
        return new SignatureResult(Result.REVOKED, resource, keyID, revocationReason);
    }

    public static SignatureResult expired(ArtifactIdentifier resource, String keyID) {
        return new SignatureResult(Result.EXPIRED, resource, keyID, null);
    }

    public static SignatureResult noSignature(ArtifactIdentifier resource) {
        return new SignatureResult(Result.NO_SIGNATURE, resource, null, null);
    }

    public static SignatureResult invalid(ArtifactIdentifier resource, String keyID) {
        return new SignatureResult(Result.INVALID, resource, keyID, null);
    }

    public static SignatureResult ok() {
        return new SignatureResult(Result.OK, null, null, null);
    }

    private SignatureResult(Result result, ArtifactIdentifier resource, String keyID, String message) {
        this.result = result;
        this.resource = resource;
        this.keyId = keyID;
        this.message = message;
    }

    public Result getResult() {
        return this.result;
    }

    public ArtifactIdentifier getResource() {
        return this.resource;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getMessage() {
        return this.message;
    }

    public static enum Result {
        OK,
        NO_MATCHING_CERT,
        REVOKED,
        EXPIRED,
        NO_SIGNATURE,
        INVALID;

    }
}

