/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.maven;

import java.net.URL;
import java.util.Objects;

public class ChannelCoordinate {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final URL url;

    public ChannelCoordinate(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null);
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(version);
    }

    public ChannelCoordinate(String groupId, String artifactId) {
        this(groupId, artifactId, null, null);
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
    }

    public ChannelCoordinate(URL url) {
        this(null, null, null, url);
        Objects.requireNonNull(url);
    }

    private ChannelCoordinate(String groupId, String artifactId, String version, URL url) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExtension() {
        return "yaml";
    }

    public String getClassifier() {
        return "channel";
    }
}

