/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel.maven;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.ChannelMetadataCoordinate;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channel.version.VersionMatcher;

public class VersionResolverFactory
implements MavenVersionsResolver.Factory {
    private static final Logger LOG = Logger.getLogger(VersionResolverFactory.class);
    public static final RepositoryPolicy DEFAULT_REPOSITORY_POLICY = new RepositoryPolicy(true, "always", "fail");
    public static final Function<Repository, RemoteRepository> DEFAULT_REPOSITORY_MAPPER = r -> new RemoteRepository.Builder(r.getId(), "default", r.getUrl()).setPolicy(DEFAULT_REPOSITORY_POLICY).build();
    private final RepositorySystem system;
    private final RepositorySystemSession session;
    private final Function<Repository, RemoteRepository> repositoryFactory;

    public VersionResolverFactory(RepositorySystem system, RepositorySystemSession session) {
        this(system, session, DEFAULT_REPOSITORY_MAPPER);
    }

    public VersionResolverFactory(RepositorySystem system, RepositorySystemSession session, Function<Repository, RemoteRepository> repositoryFactory) {
        this.system = system;
        this.session = session;
        this.repositoryFactory = repositoryFactory;
    }

    public MavenVersionsResolver create(Collection<Repository> repositories) {
        Objects.requireNonNull(repositories);
        List<RemoteRepository> mvnRepositories = repositories.stream().map(this.repositoryFactory::apply).collect(Collectors.toList());
        return this.create(mvnRepositories);
    }

    private MavenResolverImpl create(List<RemoteRepository> mvnRepositories) {
        return new MavenResolverImpl(this.system, this.session, mvnRepositories);
    }

    public List<Channel> resolveChannels(List<ChannelCoordinate> channelCoords, List<RemoteRepository> repositories) throws UnresolvedMavenArtifactException, MalformedURLException {
        Objects.requireNonNull(channelCoords);
        try (MavenResolverImpl resolver = this.create(repositories);){
            List<Channel> list = resolver.resolveChannelMetadata(channelCoords).stream().map(ChannelMapper::from).collect(Collectors.toList());
            return list;
        }
    }

    private class MavenResolverImpl
    implements MavenVersionsResolver {
        private final RepositorySystem system;
        private final RepositorySystemSession session;
        private final List<RemoteRepository> repositories;

        MavenResolverImpl(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> repositories) {
            this.system = system;
            this.session = session;
            this.repositories = repositories;
        }

        public Set<String> getAllVersions(String groupId, String artifactId, String extension, String classifier) {
            Objects.requireNonNull(groupId);
            Objects.requireNonNull(artifactId);
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, "[0,)");
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest();
            versionRangeRequest.setArtifact((Artifact)artifact);
            if (this.repositories != null) {
                versionRangeRequest.setRepositories(this.repositories);
            }
            try {
                VersionRangeResult versionRangeResult = this.system.resolveVersionRange(this.session, versionRangeRequest);
                Set<String> versions = versionRangeResult.getVersions().stream().map(Version::toString).collect(Collectors.toSet());
                return versions;
            }
            catch (VersionRangeResolutionException e) {
                return Collections.emptySet();
            }
        }

        public File resolveArtifact(String groupId, String artifactId, String extension, String classifier, String version) throws UnresolvedMavenArtifactException {
            ArtifactResult result;
            Objects.requireNonNull(groupId);
            Objects.requireNonNull(artifactId);
            Objects.requireNonNull(version);
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version);
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact((Artifact)artifact);
            if (this.repositories != null) {
                request.setRepositories(this.repositories);
            }
            try {
                result = this.system.resolveArtifact(this.session, request);
            }
            catch (ArtifactResolutionException ex) {
                throw new UnresolvedMavenArtifactException(ex.getLocalizedMessage(), (Throwable)ex, Collections.singleton(new ArtifactCoordinate(groupId, artifactId, extension, classifier, version)));
            }
            return result.getArtifact().getFile();
        }

        public List<File> resolveArtifacts(List<ArtifactCoordinate> coordinates) throws UnresolvedMavenArtifactException {
            Objects.requireNonNull(coordinates);
            ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
            for (ArtifactCoordinate coord : coordinates) {
                DefaultArtifact artifact = new DefaultArtifact(coord.getGroupId(), coord.getArtifactId(), coord.getClassifier(), coord.getExtension(), coord.getVersion());
                ArtifactRequest request = new ArtifactRequest();
                request.setArtifact((Artifact)artifact);
                if (this.repositories != null) {
                    request.setRepositories(this.repositories);
                }
                requests.add(request);
            }
            try {
                List artifactResults = this.system.resolveArtifacts(this.session, requests);
                return artifactResults.stream().map(ArtifactResult::getArtifact).map(Artifact::getFile).collect(Collectors.toList());
            }
            catch (ArtifactResolutionException ex) {
                Set failed = ex.getResults().stream().filter(r -> r.getArtifact() == null).map(res -> res.getRequest().getArtifact()).map(a -> new ArtifactCoordinate(a.getGroupId(), a.getArtifactId(), a.getExtension(), a.getClassifier(), a.getVersion())).collect(Collectors.toSet());
                throw new UnresolvedMavenArtifactException(ex.getLocalizedMessage(), (Throwable)ex, failed);
            }
        }

        public List<URL> resolveChannelMetadata(List<? extends ChannelMetadataCoordinate> coords) throws UnresolvedMavenArtifactException {
            Objects.requireNonNull(coords);
            ArrayList<URL> channels = new ArrayList<URL>();
            for (ChannelMetadataCoordinate channelMetadataCoordinate : coords) {
                if (channelMetadataCoordinate.getUrl() != null) {
                    LOG.infof("Resolving channel metadata at %s", (Object)channelMetadataCoordinate.getUrl());
                    channels.add(channelMetadataCoordinate.getUrl());
                    continue;
                }
                String version = channelMetadataCoordinate.getVersion();
                if (version == null) {
                    Set<String> versions = this.getAllVersions(channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId(), channelMetadataCoordinate.getExtension(), channelMetadataCoordinate.getClassifier());
                    Optional latestVersion = VersionMatcher.getLatestVersion(versions);
                    version = (String)latestVersion.orElseThrow(() -> {
                        throw new UnresolvedMavenArtifactException(String.format("Unable to resolve the latest version of channel metadata %s:%s", coord.getGroupId(), coord.getArtifactId()));
                    });
                }
                LOG.infof("Resolving channel metadata from Maven artifact %s:%s:%s", (Object)channelMetadataCoordinate.getGroupId(), (Object)channelMetadataCoordinate.getArtifactId(), (Object)version);
                File channelArtifact = this.resolveArtifact(channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId(), channelMetadataCoordinate.getExtension(), channelMetadataCoordinate.getClassifier(), version);
                try {
                    channels.add(channelArtifact.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new UnresolvedMavenArtifactException("Unable to resolve channel metadata.", (Throwable)e, Set.of(new ArtifactCoordinate(channelMetadataCoordinate.getGroupId(), channelMetadataCoordinate.getArtifactId(), channelMetadataCoordinate.getExtension(), channelMetadataCoordinate.getClassifier(), channelMetadataCoordinate.getVersion())));
                }
            }
            return channels;
        }

        public String getMetadataReleaseVersion(String groupId, String artifactId) {
            Objects.requireNonNull(groupId);
            Objects.requireNonNull(artifactId);
            List<MetadataResult> metadataResults = this.getMavenMetadata(groupId, artifactId);
            Function<org.apache.maven.artifact.repository.metadata.Metadata, String> getVersion = m -> m.getVersioning().getRelease();
            return this.findLatestMetadataVersion(metadataResults, getVersion, groupId, artifactId);
        }

        public String getMetadataLatestVersion(String groupId, String artifactId) {
            Objects.requireNonNull(groupId);
            Objects.requireNonNull(artifactId);
            List<MetadataResult> metadataResults = this.getMavenMetadata(groupId, artifactId);
            return this.findLatestMetadataVersion(metadataResults, m -> m.getVersioning().getLatest(), groupId, artifactId);
        }

        private String findLatestMetadataVersion(List<MetadataResult> metadataResults, Function<org.apache.maven.artifact.repository.metadata.Metadata, String> getVersion, String groupId, String artifactId) {
            MetadataXpp3Reader reader = new MetadataXpp3Reader();
            return metadataResults.stream().filter(r -> r.getMetadata() != null).map(m -> m.getMetadata().getFile()).map(f -> {
                try {
                    return reader.read((Reader)new FileReader((File)f));
                }
                catch (IOException | XmlPullParserException e) {
                    ArtifactCoordinate requestedArtifact = new ArtifactCoordinate(groupId, artifactId, null, null, "*");
                    throw new UnresolvedMavenArtifactException(e.getLocalizedMessage(), e, Set.of(requestedArtifact));
                }
            }).filter(m -> m.getVersioning() != null).map(getVersion).filter(s -> s != null && !s.isEmpty()).max(VersionMatcher.COMPARATOR).orElseThrow(() -> new UnresolvedMavenArtifactException("No versioning information found in metadata.", Set.of(new ArtifactCoordinate(groupId, artifactId, null, null, "*"))));
        }

        private List<MetadataResult> getMavenMetadata(String groupId, String artifactId) {
            DefaultMetadata metadata = new DefaultMetadata(groupId, artifactId, "maven-metadata.xml", Metadata.Nature.RELEASE);
            List requests = this.repositories.stream().map(r -> {
                MetadataRequest metadataRequest = new MetadataRequest();
                metadataRequest.setMetadata((Metadata)metadata);
                metadataRequest.setRepository(r);
                return metadataRequest;
            }).collect(Collectors.toList());
            List metadataResults = this.system.resolveMetadata(this.session, requests);
            return metadataResults;
        }
    }
}

