/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.client.config;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.client.config.SelectingXMLStreamReader;
import org.wildfly.client.config.XIncludeXMLStreamReader;
import org.wildfly.client.config._private.ConfigMessages;

public class ClientConfiguration {
    private final XMLInputFactory xmlInputFactory;
    private final URI configurationUri;

    ClientConfiguration(XMLInputFactory xmlInputFactory, URI configurationUri) {
        this.xmlInputFactory = xmlInputFactory;
        this.configurationUri = configurationUri;
    }

    XMLInputFactory getXmlInputFactory() {
        return this.xmlInputFactory;
    }

    public URI getConfigurationUri() {
        return this.configurationUri;
    }

    public ConfigurationXMLStreamReader readConfiguration(Set<String> recognizedNamespaces) throws ConfigXMLParseException {
        XIncludeXMLStreamReader reader = new XIncludeXMLStreamReader(ConfigurationXMLStreamReader.openUri(this.configurationUri, this.xmlInputFactory));
        try {
            if (reader.hasNext()) {
                switch (reader.nextTag()) {
                    case 1: {
                        if (reader.getNamespaceURI() != null || !"configuration".equals(reader.getLocalName())) {
                            throw ConfigMessages.msg.unexpectedElement(reader.getName(), reader.getLocation());
                        }
                        return new SelectingXMLStreamReader(true, reader, recognizedNamespaces);
                    }
                }
                throw ConfigMessages.msg.unexpectedContent(ConfigurationXMLStreamReader.eventToString(reader.getEventType()), reader.getLocation());
            }
            reader.close();
            return null;
        }
        catch (Throwable t) {
            try {
                reader.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    public static ClientConfiguration getInstance(URI configurationUri) throws MalformedURLException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        configurationUri.toURL();
        return new ClientConfiguration(xmlInputFactory, configurationUri);
    }
}

