/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.build.plugin.ModuleParseResult;

class ModuleParser {
    ModuleParser() {
    }

    static ModuleParseResult parse(Path moduleRoot, Path inputFile) throws IOException, XMLStreamException {
        ModuleParseResult result = new ModuleParseResult(moduleRoot, inputFile);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFile.toFile()));
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            reader.require(7, null, null);
            boolean done = false;
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!done && reader.getLocalName().equals("module")) {
                            ModuleParser.parseModule(reader, result);
                            done = true;
                            break;
                        }
                        if (done || !reader.getLocalName().equals("module-alias")) break;
                        ModuleParser.parseModuleAlias(reader, result);
                        done = true;
                        break;
                    }
                    case 8: {
                        ModuleParseResult moduleParseResult = result;
                        return moduleParseResult;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing " + inputFile, e);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception ignore) {}
        }
        return result;
    }

    private static void parseModule(XMLStreamReader reader, ModuleParseResult result) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = "main";
        for (int i = 0; i < count; ++i) {
            if ("name".equals(reader.getAttributeName(i).getLocalPart())) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (!"slot".equals(reader.getAttributeName(i).getLocalPart())) continue;
            slot = reader.getAttributeValue(i);
        }
        result.identifier = ModuleIdentifier.create(name, (String)slot);
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (reader.getLocalName().equals("dependencies")) {
                        ModuleParser.parseDependencies(reader, result);
                    }
                    if (!reader.getLocalName().equals("resources")) break;
                    ModuleParser.parseResources(reader, result);
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals("module")) break;
                    return;
                }
            }
        }
    }

    private static void parseModuleAlias(XMLStreamReader reader, ModuleParseResult result) throws XMLStreamException {
        String targetName = "";
        String targetSlot = "main";
        String name = null;
        String slot = null;
        boolean optional = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String localName = reader.getAttributeLocalName(i);
            if (localName.equals("target-name")) {
                targetName = reader.getAttributeValue(i);
                continue;
            }
            if (localName.equals("target-slot")) {
                targetSlot = reader.getAttributeValue(i);
                continue;
            }
            if (localName.equals("name")) {
                name = reader.getAttributeValue(i);
                continue;
            }
            if (!localName.equals("slot")) continue;
            slot = reader.getAttributeValue(i);
        }
        ModuleIdentifier moduleId = ModuleIdentifier.create((String)targetName, (String)targetSlot);
        result.identifier = ModuleIdentifier.create(name, slot);
        result.dependencies.add(new ModuleParseResult.ModuleDependency(moduleId, optional));
    }

    private static void parseDependencies(XMLStreamReader reader, ModuleParseResult result) throws XMLStreamException {
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (!reader.getLocalName().equals("module")) break;
                    String name = "";
                    String slot = "main";
                    boolean optional = false;
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        String localName = reader.getAttributeLocalName(i);
                        if (localName.equals("name")) {
                            name = reader.getAttributeValue(i);
                            continue;
                        }
                        if (localName.equals("slot")) {
                            slot = reader.getAttributeValue(i);
                            continue;
                        }
                        if (!localName.equals("optional")) continue;
                        optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    }
                    ModuleIdentifier moduleId = ModuleIdentifier.create((String)name, (String)slot);
                    result.dependencies.add(new ModuleParseResult.ModuleDependency(moduleId, optional));
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals("dependencies")) break;
                    return;
                }
            }
        }
    }

    private static void parseResources(XMLStreamReader reader, ModuleParseResult result) throws XMLStreamException {
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String localName;
                    int i;
                    if (reader.getLocalName().equals("resource-root")) {
                        String path = "";
                        for (i = 0; i < reader.getAttributeCount(); ++i) {
                            localName = reader.getAttributeLocalName(i);
                            if (!localName.equals("path")) continue;
                            path = reader.getAttributeValue(i);
                        }
                        result.resourceRoots.add(path);
                        break;
                    }
                    if (!reader.getLocalName().equals("artifact")) break;
                    String name = "";
                    for (i = 0; i < reader.getAttributeCount(); ++i) {
                        localName = reader.getAttributeLocalName(i);
                        if (!localName.equals("name")) continue;
                        name = reader.getAttributeValue(i);
                    }
                    result.artifacts.add(name);
                    break;
                }
                case 2: {
                    if (!reader.getLocalName().equals("resources")) break;
                    return;
                }
            }
        }
    }
}

